const fs = require('fs');
const ora = require('ora');
const path = require('path');
const { exec } = require('child_process');

const outputPath = path.resolve(__dirname, '../lib');

// 删除文件夹
const delPath = path => {
  if (!path.includes(process.cwd())) {
    console.log('只能操作当前项目');
    throw path;
  }
  const info = fs.statSync(path);
  if (info.isDirectory()) {
    // 目录
    const data = fs.readdirSync(path);
    if (data.length > 0) {
      data.forEach((f, i) => {
        delPath(`${path}/${f}`); // 使用递归
        if (i == data.length - 1) {
          // 删了目录里的内容就删掉这个目录
          delPath(`${path}`);
        }
      });
    } else {
      fs.rmdirSync(path); // 删除空目录
    }
  } else if (info.isFile()) {
    fs.unlinkSync(path); // 删除文件
  }
};

// 清除输出目录
if (fs.existsSync(outputPath)) {
  delPath(outputPath);
}

const cmd = 'vue-cli-service build --target lib --name eagle --dest lib packages/index.js';

const spinner = ora('编译中...').start();

exec(cmd, function(error, stdout, stderr) {
  if (error) {
    throw error;
  }
  fs.readdirSync(outputPath).forEach(file => {
    if (file !== 'eagle.css') {
      if (file === 'eagle.umd.min.js') {
        fs.renameSync(path.resolve(outputPath, file), path.resolve(outputPath, 'eagle.js'));
      } else {
        fs.unlinkSync(path.resolve(outputPath, file));
      }
    }
  });
  spinner.succeed('编译完成');
});
