const path = require('path');

module.exports = {
  // 修改 src 为 examples
  pages: {
    index: {
      entry: 'examples/main.js',
      template: 'public/index.html',
      filename: 'index.html',
    },
  },
  css: {
    loaderOptions: {
      sass: {
        additionalData: (content, loaderContext) => {
          const { resourcePath, rootContext } = loaderContext;
          const relativePath = path.relative(rootContext, resourcePath);
          if (relativePath.includes('variables.scss')) {
            return content;
          }
          return `@import "@/styles/variables.scss";${content}`;
        },
      },
    },
  },
  // eslint-loader 是否在保存的时候检查
  lintOnSave: true,
  // webpack配置扩展markdown
  configureWebpack: config => {
    config.resolve.alias['@'] = path.resolve(__dirname, 'examples');
    config.module.rules.push({
      test: /\.md$/,
      use: ['vue-loader', path.resolve(__dirname, './webpack/markdown-loader.js')],
    });
  },
  // webpack-dev-server 相关配置
  devServer: {
    open: true,
    host: '0.0.0.0',
    port: 8888,
    https: false,
    hotOnly: false,
    disableHostCheck: true,
  },
  productionSourceMap: false, // 打包组件库时不生成source map
};
