import tableProps from './props';

export default {
  name: 'Table',
  props: {
    value: {
      type: Array,
      default() {
        return [];
      },
    },
    columns: {
      type: Array,
      default() {
        return [];
      },
    },
    editable: Boolean,
    editall: Boolean,
    clickable: Boolean,
    disabled: Boolean,
    ...tableProps,
  },
  render(h) {
    return h(`eagle-table-${this.editable ? 'editable' : 'normal'}`, { props: { ...this._props }, scopedSlots: this.$scopedSlots, on: this.$listeners });
  },
};
