import Vue from 'vue';
import ZTable from './table/index';
import ZTableNormal from './table/normal';
import ZTableEditable from './table/editable';
import ElImageViewer from './upload/image-viewer';

let components = {};

const componentsFiles = require.context('./', true, /index\.vue/);
componentsFiles.keys().forEach(path => {
  const component = componentsFiles(path);
  components[component.default.name] = component.default;
});

// 给组件库配置install方法
const install = function(Vue, opts = {}) {
  components[ZTable.name] = ZTable;
  components[ZTableNormal.name] = ZTableNormal;
  components[ZTableEditable.name] = ZTableEditable;
  Object.values(components).forEach(component => {
    // 组件前缀
    const prefix = opts.name || 'eagle';
    // 配置组件名称
    const name = prefix + component.name;
    component.name = name;
    if (component.props && component.props.size && component.props.size.default && opts.size) {
      component.props.size.default = opts.size;
    }
    if (component.computed) {
      component.computed.zAlias = () => opts.alias || {};
      component.computed.zHttp = () => opts.http;
    } else {
      component.computed = {
        zAlias: () => {},
        zHttp: () => opts.http,
      };
    }
    // 给每个子组件配置install方法
    component.install = function(Vue) {
      Vue.component(name, component);
    };
    // 将每个子组件注册为全局组件
    Vue.component(name, component);
  });
  ElImageViewer.install = function(Vue) {
    Vue.component(ElImageViewer.name, ElImageViewer);
  };
  Vue.component(ElImageViewer.name, ElImageViewer);
  Vue.directive('inner', {
    bind: function(el) {
      const inputInner = el.querySelector('.el-input__inner');
      if (inputInner) {
        inputInner.style.border = 0;
      }
    },
  });
};

let instance = null;

const closeImageViewer = function(force) {
  if (instance) {
    if (force === true) {
      document.body.removeChild(instance.$el);
    } else {
      instance.$el.className = `${instance.$el.className} viewer-fade-leave-active viewer-fade-leave-to`;
      setTimeout(function() {
        document.body.removeChild(instance.$el);
        instance = null;
      }, 200);
    }
  }
};

const _ImageViewer = function({ index, src, list, ...other }) {
  if (instance) {
    closeImageViewer(true);
  }
  const ImageViewer = Vue.extend(ElImageViewer);
  instance = new ImageViewer({ el: document.createElement('div') });
  Object.assign(instance, {
    index: src ? list.findIndex(url => url === src) : index || 0,
    urlList: list,
    ...other,
    onClose: closeImageViewer,
  });
  document.body.appendChild(instance.$el);
};

export const ImageViewer = _ImageViewer;

ImageViewer.close = closeImageViewer;

export default {
  install,
  ...components,
};
