# Mixin Page 标准页

常规分页逻辑的混入配置

## 基础用法

`MIX_PAGE`混入配置项，会默认提供一套分页查询的业务逻辑。

::: snippet 预置了许多业务逻辑，避免重复维护相同的业务逻辑

```html
<template>
  <div>
    <div class="page-search">
      <el-form :model="searchModel" label-width="80px" size="small">
        <el-row>
          <el-col :span="6">
            <el-form-item label="姓名">
              <el-input v-model.trim="searchModel.name"></el-input>
            </el-form-item>
          </el-col>
          <el-col :span="18" style="text-align: right;">
            <el-form-item>
              <el-button-group>
                <el-button :loading="loading" type="primary" @click="onSearch">查询</el-button>
                <el-button @click="onReset">重置</el-button>
              </el-button-group>
            </el-form-item>
          </el-col>
        </el-row>
      </el-form>
    </div>
    <div class="page-action">
      <el-button type="primary" size="small">新增</el-button>
    </div>
    <el-table class="page-table" v-loading="loading" v-bind="tableProps" :data="tableData">
      <el-table-column label="姓名" prop="name" min-width="100" show-overflow-tooltip></el-table-column>
      <el-table-column label="年龄" prop="age" min-width="120" show-overflow-tooltip></el-table-column>
    </el-table>
    <el-pagination class="page-pagination" v-bind="paginationProps" v-on="paginationEvent"></el-pagination>
  </div>
</template>

<script>
// import MIX_PAGE from '@/mixins/page'; 注：使用时解除此注释

export default {
  mixins: [MIX_PAGE],
  data() {
    return {
      searchModel: {
        name: '',
      },
      tableData: [
        { id: '0', name: '李饼', age: 32 },
        { id: '1', name: '陈拾', age: 20 },
      ],
    };
  },
};
</script>

```

:::

## 推荐用法

与`eagle-form`、`eagle-table`等组件配合，可以最大限度的减少代码量，开发者只需要重点关心与业务相关的数据渲染

::: snippet `MIX_PAGE`混入配置项，会默认提供一套分页查询的业务逻辑。

```html
<template>
  <div>
    <div class="page-search">
      <eagle-form :model="searchModel" label-width="80px" size="small" span="6">
        <eagle-form-item label="姓名" prop="name">
          <el-input v-model="searchModel.name"></el-input>
        </eagle-form-item>
        <eagle-form-item span="18" style="text-align: right">
          <el-button-group>
            <el-button :loading="loading" type="primary" @click="onSearch">查询</el-button>
            <el-button @click="onReset">重置</el-button>
          </el-button-group>
        </eagle-form-item>
      </eagle-form>
    </div>
    <div class="page-action">
      <el-button type="primary" size="small">新增</el-button>
    </div>
    <eagle-table class="page-table" v-loading="loading" v-bind="tableProps">
      <el-table-column prop="name" label="姓名"></el-table-column>
      <el-table-column prop="age" label="年龄"></el-table-column>
    </eagle-table>
    <el-pagination class="page-pagination" v-bind="paginationProps" v-on="paginationEvent"></el-pagination>
  </div>
</template>

<script>
// import MIX_PAGE from '@/mixins/page'; 注：使用时解除此注释

export default {
  mixins: [MIX_PAGE],
  data() {
    return {
      auto: true,
      searchModel: {
        name: '',
      },
    };
  },
  methods: {
    searchAPI(params) {
      return new Promise(resolve => {
        setTimeout(() => {
          const source = [
            { id: '0', name: '李饼', age: 32 },
            { id: '1', name: '陈拾', age: 20 },
            { id: '3', name: '王七', age: 26 },
            { id: '4', name: '崔倍', age: 27 },
            { id: '5', name: '孙豹', age: 38 },
            { id: '6', name: '庞柏', age: 42 },
            { id: '7', name: '蔡疏', age: 60 },
            { id: '8', name: '卢纳', age: 55 },
          ];
          const list = source.filter(item => `${item.name}`.includes(params.name));
          resolve({
            result: list,
            totalCount: list.length
          });
        }, 500);
      });
    },
  },
};
</script>

```

:::

## 弹出框表单

常用的弹出框表单提交示例

::: snippet 新增修改共用表单示例

```html
<template>
  <div>
    <div class="page-search">
      <eagle-form :model="searchModel" label-width="80px" size="small" span="6">
        <eagle-form-item label="姓名" prop="name">
          <el-input v-model="searchModel.name"></el-input>
        </eagle-form-item>
        <eagle-form-item span="18" style="text-align: right">
          <el-button-group>
            <el-button :loading="loading" type="primary" @click="onSearch">查询</el-button>
            <el-button @click="onReset">重置</el-button>
          </el-button-group>
        </eagle-form-item>
      </eagle-form>
    </div>
    <div class="page-action">
      <el-button type="primary" size="small" @click="openNew">新增</el-button>
    </div>
    <eagle-table class="page-table" v-loading="loading" v-bind="tableProps">
      <el-table-column prop="name" label="姓名"></el-table-column>
      <el-table-column prop="age" label="年龄"></el-table-column>
      <el-table-column label="操作" width="80">
        <template #default="{ row, $index }">
          <el-button size="mini" type="text" title="编辑" @click="openEdit({ row, index: $index })">编辑</el-button>
        </template>
      </el-table-column>
    </eagle-table>
    <el-pagination class="page-pagination" v-bind="paginationProps" v-on="paginationEvent"></el-pagination>
    <el-dialog :title="dialogTitle" :visible.sync="dialogVisible" width="400px" @closed="resetForm">
      <eagle-form ref="form" :model="form" :rules="formRules" label-width="60px" size="small">
        <eagle-form-item label="姓名" prop="name">
          <el-input v-model="form.name"></el-input>
        </eagle-form-item>
        <eagle-form-item label="年龄" prop="age">
          <el-input v-model="form.age"></el-input>
        </eagle-form-item>
        <eagle-form-item>
          <el-button type="primary" :loading="submitting" @click="onSubmit">确定</el-button>
          <el-button @click="onCancel">取消</el-button>
        </eagle-form-item>
      </eagle-form>
    </el-dialog>
  </div>
</template>

<script>
// import MIX_PAGE from '@/mixins/page'; 注：使用时解除此注释

export default {
  mixins: [MIX_PAGE],
  data() {
    return {
      auto: true,
      searchModel: {
        name: '',
      },
      form: {
        id: '',
        name: '',
        age: '',
      },
      formRules: {
        name: [{ required: true, message: '请输入姓名' }]
      },
      dialogVisible: false,
      dialogMode: 'new',
    };
  },
  computed: {
    dialogTitle() {
      return this.dialogMode === 'edit' ? '编辑' : '新增';
    }
  },
  methods: {
    searchAPI(params) {
      return new Promise(resolve => {
        setTimeout(() => {
          const source = [
            { id: '0', name: '李饼', age: 32 },
            { id: '1', name: '陈拾', age: 20 },
            { id: '3', name: '王七', age: 26 },
            { id: '4', name: '崔倍', age: 27 },
            { id: '5', name: '孙豹', age: 38 },
            { id: '6', name: '庞柏', age: 42 },
            { id: '7', name: '蔡疏', age: 60 },
            { id: '8', name: '卢纳', age: 55 },
          ];
          const list = source.filter(item => `${item.name}`.includes(params.name));
          resolve({
            result: list,
            totalCount: list.length
          });
        }, 300);
      });
    },
    openNew() {
      this.dialogMode = 'new';
      this.dialogVisible = true;
    },
    openEdit({ row }) {
      this.dialogMode = 'edit';
      this.form = this.cloneDeep(row);
      this.dialogVisible = true;
    },
    onSubmit() {
      this.$refs.form.validate(valid => {
        if (valid) {
          let data = this.cloneDeep(this.form);
          if (this.dialogMode === 'new') {
            delete data.id;
            console.log('新增提交：', data);
          } else if (this.dialogMode === 'edit') {
            console.log('修改提交：', data);
          }
          this.submitting = true;
          setTimeout(() => {
            this.submitting = false;
            this.dialogVisible = false;
            this.search();
          }, 1500);
        }
      });
    },
    onCancel() {
      this.dialogVisible = false;
    },
    resetForm() {
      this.form = this.getOriginData().form;
      this.$refs.form.resetFields();
    }
  },
};
</script>

```

:::

## 内置方法

本配置中，已经混入了`MIX_ORIGIN`，内置了`originData`对象和`getOriginData`方法。
