# Mixin Origin 初始值

常用Vue页面初始值的混入配置

## 基础用法

`MIX_ORIGIN`混入配置项，会默认记录当前页面初始值。

::: snippet `originData`表示当前页面的初始data值，`getOriginData`方法可获得一个新的初始值对象

```html
<template>
  <div>
    <div>model初始值：{{ originData.model }}</div>
    <el-input v-model="model.name" size="mini" style="width: 200px; margin: 10px 0"></el-input>
    <el-button type="primary" size="mini" @click="handleReset">重置</el-button>
    <div>model当前值：{{ model }}</div>
  </div>
</template>

<script>
// import MIX_ORIGIN from '@/mixins/origin'; 注：使用时解除此注释

export default {
  mixins: [MIX_ORIGIN],
  data() {
    return {
      model: {
        name: '张三',
      },
    };
  },
  methods: {
    handleReset() {
      // 注意：切记不可写成 this.model = this.originData.model; 否则会导致originData被改变！
      this.model = this.getOriginData().model;
    }
  },
};
</script>
```

:::
