# 表格设计规范

## 一、表头

### 对齐方式

文本信息左对齐，因为现代人的阅读方式习惯从左到右，符合正常的心智；

数据信息右对齐，更加方便数字大小的直观对比；

固定内容居中对齐，更好的信息呈现及表格空间的节省；

表头与信息内容对齐方式一致，一致性以达到简化，降低视觉噪音。

### 排序

按照时间、名称降序排列

## 二、列

### 对齐方式

与表头对齐方式保持一致

### 列宽

默认不设置列宽，自动适配

时间YYYY-MM-DD HH:mm:ss，最小宽度140

### 数据截断

动态内容，无法确认宽度时，默认设置show-overflow-tooltip

内容大于240时，必须设置show-overflow-tooltip

### 详情入口

默认为第一列，如订单号、运单号、名称

特殊情况下可显示在操作列

### 展开行

列数较多且内容不便用表格展示时，可以设置展开行

## 三、单元格

### 默认文本

样式默认即可

使用插槽自定义时，进行空值处理，防止出现null、undefined

### 组件

特点、标签类的内容，可以使用el-tag进行展示

布尔类型的数据，可以用el-tag或者红绿指示点，避免通篇显示是否

### 行内编辑

修改内容只有1个值时，使用行内编辑

修改内容大于1个值时，使用el-dialog或el-drawer

### 快捷操作

频繁复制的内容，设置快速复制按钮

入口列的内容，使用el-link，表示可以点击跳转

行内编辑单元格，显示行内编辑操作按钮

## 四、操作列

### 默认项

默认悬浮固定在表格右侧

默认展示编辑、删除按钮

使用图标代替文字展示操作按钮，避免操作列因大量文字展示过长

设置图标时，必须设置title属性，鼠标悬停时显示说明内容

### 宽度

设置与当前操作行按钮数量总宽度相当，避免出现多余空位

出现过多操作按钮，保留使用频率最高的按钮，其余的显示为“更多”，下拉展示

### 展示方式

文本

图标

下拉列表

### 功能提示

设置title对当前功能进行描述

## 五、浮动列

### 表格选择列

宽度固定40

### 主要内容列

列数多时左侧固定

设置快捷操作，跳转入口、快速复制

## 六、表格设置

### 宽度

默认100%即可，不要设置固定宽度

### 高度

正常情况下，不设置表格的固定高度

最大高度以当前分页条数为准

### 边框

开启边框

### 斑马纹

不设置斑马纹

### 树形数据

包含层级的功能，如菜单、组织等功能，使用树形数据展示

## 七、业务数据

### 常规数字

右对齐

### 金额数字

千分位、保留两位小数、右对齐

### 时间展示

格式化YYYY-MM-DD HH:mm:ss

### 类型标签

单个描述性特点时，使用el-tag

多个同类描述性特点时，在单个列中同时展示多个el-tag

### 活动指示器

布尔类型值，优先用指示器，避免直接显示“是”“否”
