# Upload 上传

文件上传，支持图片与文件

## 基础用法

默认支持图片和图片一起上传

::: snippet 配置项`action`、`headers`、`data`与**Element**中的**el-upload**相同，值的格式为逗号分隔的字符串

```html
<template>
  <eagle-upload v-model="model" action="http://xxx" :headers="headers" :data="uploadData"></eagle-upload>
</template>

<script>
export default {
  data() {
    return {
      model: '',
      headers: {
        'Authorization': 'Bearer xxx'
      },
      uploadData: {
        module: 'tms'
      }
    }
  },
}
</script>
```

:::

## 限制上传

可以限制图片上传或者文件上传

::: snippet `type`设置上传模式，`limit`限制上传数量，`file-type`限制文件上传格式

```html
<template>
  <div>
    <div>
      <div>文件上传：</div>
      <eagle-upload v-model="file" type="file" action="http://xxx" :limit="1" :headers="headers" size="mini"></eagle-upload>
    </div>
    <div>
      <div>图片上传：</div>
      <eagle-upload v-model="image" type="image" action="http://xxx" :limit="2" :headers="headers" size="mini"></eagle-upload>
    </div>
    <div>
      <div>限制文件格式：</div>
      <eagle-upload v-model="fileType" type="file" file-type="pdf" action="http://xxx" :limit="1" :headers="headers" size="mini"></eagle-upload>
    </div>
  </div>
</template>

<script>
export default {
  data() {
    return {
      file: '',
      image: '',
      fileType: '',
      headers: {
        'Authorization': 'Bearer xxx'
      }
    }
  },
}
</script>
```

:::

## 多选与拖拽

可以多选上传及拖拽上传

::: snippet `multiple`设置多选上传，`drag`设置拖拽上传

```html
<template>
  <eagle-upload v-model="model" action="http://xxx" :headers="headers" multiple drag :limit="3"></eagle-upload>
</template>

<script>
export default {
  data() {
    return {
      model: '',
      headers: {
        'Authorization': 'Bearer xxx'
      },
    }
  },
}
</script>
```

:::

## 角标删除与提醒

默认支持角标删除样式，以及配置删除前确认提示

::: snippet `corner-close`开启角标删除，`delete-confirm`设置删除确认提示

```html
<template>
  <eagle-upload v-model="model" action="http://xxx" :headers="headers" multiple drag corner-close delete-confirm :limit="3"></eagle-upload>
</template>

<script>
export default {
  data() {
    return {
      model: '',
      headers: {
        'Authorization': 'Bearer xxx'
      },
    }
  },
}
</script>
```

:::

## 只读模式

可配置只读模式用于显示

::: snippet `readonly`开启只读模式

```html
<template>
  <eagle-upload v-model="model" corner-close readonly></eagle-upload>
</template>

<script>
export default {
  data() {
    return {
      model: 'http://clips.vorwaerts-gmbh.de/big_buck_bunny.mp3,http://clips.vorwaerts-gmbh.de/big_buck_bunny.mp4,http://clips.vorwaerts-gmbh.de/big_buck_bunny.pdf',
    }
  },
}
</script>
```

:::

## API

## Attribute 属性

参数|说明|类型|可选值|默认值
-|-|-|-|-
value | 值 | String | - | -
type | 上传类型 | String | all,image,file | all
file-type | 上传文件类型限制,仅在type为file时生效 | String | - | -
disabled | 是否禁用 | Boolean | - | false
multiple | 是否支持多选文件 | Boolean | - | false
limit | 最大上传数量 | Number | - | -
drag | 是否启用拖拽上传 | Boolean | - | false
draggable | 是否启用拖拽改变顺序(需要项目安装vuedraggable并注册为draggable) | Boolean | - | false
action | 上传地址 | String | - | -
headers | 自定义请求头 | Object | - | {}
delete-confirm | 删除图片时弹出确认框 | Boolean | - | false
data | 上传时附带的额外参数 | Object | - | {}
name | 上传文件字段名 | String | - | file
response-filter | 返回值处理函数 | Function | - | -
before-upload | 上传文件之前的钩子 | Function | - | -
size | 大小 | String | mini, small, large | large
http | HTTP请求库 | Function | - | -
http-request | 自定义请求方法 | Function | - | -
corner-close | 是否开启角标删除按钮 | Boolean | - | false

## Events 事件

事件名称|说明|回调参数
-|-|-
upload | 单个文件上传成功后的事件 | 请求response

## Slots 插槽

名称|说明|方法
-|-|-
image-viewer | 自定义图片查看器 | show, index, list, close, open
