# Table 表格

拓展ElementUI的`el-table`

## 基础用法

基本参数与ElementUI的`el-table`相同。

::: snippet 支持来自表单的`size`继承

```html
<template>
  <el-form size="mini">
    <eagle-table :data="tableData" border>
      <el-table-column prop="name" label="姓名"></el-table-column>
      <el-table-column prop="age" label="年龄"></el-table-column>
      <el-table-column prop="gender" label="性别"></el-table-column>
    </eagle-table>
  </el-form>
</template>

<script>
export default {
  data() {
    return {
      tableData: [
        { name: '张三', age: '31', gender: '男' },
        { name: '李四', age: '27', gender: '女' },
        { name: '王五', age: '16', gender: '男' },
      ],
    };
  },
}
</script>
```

:::

## 配置项

可以通过配置项列表快速生成表格列

::: snippet 设置`columns`配置表格列，插槽`header-列字段名`可自定义表头的内容，插槽`cell-列字段名`可自定义列单元格的内容。

```html
<template>
  <eagle-table :data="tableData" border size="small" :columns="columns">
    <template #header-age>年龄 <i class="el-icon-question"></i></template>
    <template #cell-gender="{ value }">
      <el-tag size="mini">{{ value }}</el-tag>
    </template>
  </eagle-table>
</template>

<script>
export default {
  data() {
    return {
      tableData: [
        { name: '张三', age: '31', gender: '男' },
        { name: '李四', age: '27', gender: '女' },
        { name: '王五', age: '16', gender: '男' },
      ],
      columns: [
        { prop: 'name', label: '姓名' },
        { prop: 'age', label: '年龄' },
        { prop: 'gender', label: '性别' },
      ]
    };
  },
}
</script>
```

:::

## 追加列

使用配置项时，**新增的列**则默认追加在**配置项列**之后，使用`left`插槽可在表格的最左侧插入列，顺序在**配置项列**之前

::: snippet 设置`columns`配置表格列，插槽`header-列字段名`可自定义表头的内容，插槽`cell-列字段名`可自定义列单元格的内容。

```html
<template>
  <eagle-table :data="tableData" border size="small" :columns="columns">
    <template #left>
      <el-table-column type="selection" width="40"></el-table-column>
      <el-table-column label="左侧的列">
        <template #default="{ $index }">
          内容 {{ $index }}
        </template>
      </el-table-column>
    </template>
    <el-table-column label="新增的列" width="80">
      <template #default>
        <el-button type="text">编辑</el-button>
      </template>
    </el-table-column>
  </eagle-table>
</template>

<script>
export default {
  data() {
    return {
      tableData: [
        { name: '张三', age: '31', gender: '男' },
        { name: '李四', age: '27', gender: '女' },
        { name: '王五', age: '16', gender: '男' },
      ],
      columns: [
        { prop: 'name', label: '姓名' },
        { prop: 'age', label: '年龄' },
        { prop: 'gender', label: '性别' },
      ]
    };
  },
}
</script>
```

:::

## 可编辑表格

一般用于表格的静态数据编辑，设置`editable`开启可编辑模式，设置`clickable`开启双击编辑

::: snippet 编辑功能只支持通过`columns`配置的列，`editable`设置该列是否可编辑，默认开启；插槽`editor-列字段名`可自定义列单元格的编辑器，通过解构作用域插槽获取的`value`和`onInput`改变表格的绑定值，不支持直接写`v-model`。

```html
<template>
  <div>
    <eagle-form span="6">
      <eagle-form-item>编辑模式：<el-switch v-model="editable"></el-switch></eagle-form-item>
      <eagle-form-item>编辑全部：<el-switch v-model="editall"></el-switch></eagle-form-item>
      <eagle-form-item>双击编辑：<el-switch v-model="clickable"></el-switch></eagle-form-item>
    </eagle-form>
    <eagle-table v-model="tableData" size="mini" :editable="editable" :columns="columns" border :clickable="clickable" @cell-edit-confirm="onCellEditConfirm" :editall="editall">
      <template #editor-gender="{ value, onInput, index }">
        <el-radio-group size="mini" :value="value" @input="onInput">
          <el-radio-button label="男">男</el-radio-button>
          <el-radio-button label="女">女</el-radio-button>
        </el-radio-group>
      </template>
      <template #cell-gender="{ value }">
        <el-tag size="mini" type="info" disable-transitions>{{ value }}</el-tag>
      </template>
      <el-table-column label="操作" width="80">
        <template #default="{ $index }">
          <el-button type="text" @click="deleteRow($index)">删除</el-button>
        </template>
      </el-table-column>
    </eagle-table>
  </div>
</template>

<script>
export default {
  data() {
    return {
      editall: false,
      editable: true,
      clickable: true,
      tableData: [
        { name: '张三', age: 31, gender: '男', remark: '' },
        { name: '李四', age: 27, gender: '女', remark: '' },
        { name: '王五', age: 16, gender: '男', remark: '' },
      ],
      columns: [
        { prop: 'name', label: '姓名', editable: false },
        { component: 'el-input-number', prop: 'age', label: '年龄' },
        { prop: 'gender', label: '性别' },
        { prop: 'remark', label: '备注' },
      ]
    };
  },
  methods: {
    deleteRow(index) {
      this.tableData.splice(index, 1);
    },
    onCellEditConfirm(data) {
      console.log(data);
    }
  }
}
</script>
```

:::

## API

## Attribute 属性

参数|说明|类型|可选值|默认值
-|-|-|-|-
data | 表格数据 | Array | - | -
value | 表格数据（支持v-model） | Array | - | []
columns | 表格列配置 | Array | - | []
type | 表格类型 | String | normal、editable | normal