# Select 选择器

拓展ElementUI的`el-select`，支持快捷配置数据源。

## 基础用法

适用广泛的基础单选

<div class="code-snippet-box">

::: snippet 设置`options`配置选择器数据源

```html
<template>
  <eagle-select v-model="model" :options="options"></eagle-select>
</template>

<script>
export default {
  data() {
    return {
      model: '',
      options: [
        { label: '单车', value: 'VAN' },
        { label: '牵引车', value: 'TRACTOR' }
      ],
    }
  } 
}
</script>
```

:::

::: snippet 配置`option`**插槽**可自定义选项样式

```html
<template>
  <eagle-select v-model="model" :options="options">
    <template #option="{ item, value }">
      <div style="display: flex; align-items: center; justify-content: space-between;">
        <span>{{ item.label }}</span>
        <el-tag size="mini">{{ item.type }}</el-tag>
      </div>
    </template>
  </eagle-select>
</template>

<script>
export default {
  data() {
    return {
      model: '',
      options: [
        { label: '单车', value: 'VAN', type: '国产' },
        { label: '牵引车', value: 'TRACTOR', type: '进口' }
      ],
    }
  },
}
</script>
```

:::

</div>

<div class="code-snippet-box">

::: snippet 设置`filterable`启用搜索功能

```html
<template>
  <eagle-select v-model="model" :options="options" filterable></eagle-select>
</template>

<script>
export default {
  data() {
    return {
      model: '',
      options: [
        { label: '单车', value: 'VAN' },
        { label: '牵引车', value: 'TRACTOR' }
      ],
    }
  },
}
</script>
```

:::

::: snippet 设置`clearable`可清空选项

```html
<template>
  <eagle-select v-model="model" :options="options" clearable></eagle-select>
</template>

<script>
export default {
  data() {
    return {
      model: '',
      options: [
        { label: '单车', value: 'VAN' },
        { label: '牵引车', value: 'TRACTOR' }
      ],
    }
  },
}
</script>
```

:::

</div>

<div class="code-snippet-box">

::: snippet 支持直接配置`<el-option>`子项

```html
<template>
  <eagle-select v-model="model">
    <el-option label="单车" value="VAN">单车</el-option>
    <el-option label="牵引车" value="TRACTOR">牵引车</el-option>
  </eagle-select>
</template>

<script>
export default {
  data() {
    return {
      model: '',
    }
  } 
}
</script>
```

:::

</div>

## 绑定值参数名

可以根据不同业务数据的需要，自定义下拉框的绑定值参数名。

::: snippet `labelKey`设置下拉框显示的文本，默认**label**；`valueKey`设置下拉框选项对应的值，默认**value**。

```html
<template>
  <div>
    <eagle-select v-model="model" :options="options" label-key="name" value-key="code"></eagle-select>
    <span>{{ model }}</span>
  </div>
</template>

<script>
export default {
  data() {
    return {
      model: '',
      options: [
        { name: '单车', code: 'VAN' },
        { name: '牵引车', code: 'TRACTOR' }
      ],
    }
  } 
}
</script>
```

:::

## 设置多选

多选时支持字符串或数组类型的值

<div class="code-snippet-box">

::: snippet 设置`multiple`开启多选，选中值为**数组**类型

```html
<template>
  <div>
    <eagle-select v-model="model" :options="options" multiple></eagle-select>
    <span>{{ model }}</span>
  </div>
</template>

<script>
export default {
  data() {
    return {
      model: ['zs', 'ls'],
      options: [
        { label: '张三', value: 'zs' },
        { label: '李四', value: 'ls' },
        { label: '王五', value: 'ww' }
      ],
    }
  },
}
</script>
```

:::

::: snippet 设置`stringify`后，选中值为**字符串**类型

```html
<template>
  <div>
    <eagle-select v-model="model" :options="options" multiple stringify></eagle-select>
    <span>{{ model }}</span>
  </div>
</template>

<script>
export default {
  data() {
    return {
      model: 'zs,ls',
      options: [
        { label: '张三', value: 'zs' },
        { label: '李四', value: 'ls' },
        { label: '王五', value: 'ww' }
      ],
    }
  },
}
</script>
```

:::

</div>

<div class="code-snippet-box">

::: snippet 设置`sequence`固定序列，选中顺序与数据源顺序保持一致

```html
<template>
  <div>
    <eagle-select v-model="model" :options="options" multiple sequence style="min-width: 300px;"></eagle-select>
    <span>{{ model }}</span>
  </div>
</template>

<script>
export default {
  data() {
    return {
      model: [],
      options: [
        { label: '张三', value: 'zs' },
        { label: '李四', value: 'ls' },
        { label: '王五', value: 'ww' }
      ],
    }
  },
}
</script>
```

:::

</div>

## 远程加载

可以通过设置`queryApi`自定义查询接口，必须是返回`Promise`的`Function`类型，Promise的返回值为`Array`类型，格式需要与`lebalKey`、`valueKey`项对应。

<div class="code-snippet-box">

::: snippet `queryApi`自定义查询接口

```html
<template>
  <div>
    <eagle-select v-model="model" :options="options" :queryApi="queryAPI"></eagle-select>
    <span>{{ model }}</span>
  </div>
</template>

<script>
export default {
  data() {
    return {
      model: '',
      options: [
        { label: '王七', value: 'wq' },
        { label: '陈拾', value: 'cs' },
      ]
    }
  },
  methods: {
    queryAPI(val) {
      // 正式项目使用时，可以返回axios的实例，如：
      // return this.$axios({ url: 'xxx', params: { foo: 'bar' } }).then(response => ({ result: response.result }));
      // 此处的Promise是模拟接口
      return new Promise(resolve => {
        setTimeout(() => {
          resolve({
            result: [
              { label: '王五', value: 'ww' },
              { label: '赵六', value: 'zl' },
            ]
          });
        }, 1000);
      });
    },
  }
}
</script>
```

:::

</div>

<div class="code-snippet-box">

::: snippet `lazy`设置懒加载，即初始化后不自动执行查询，而是第一次点击下拉时加载

```html
<template>
  <div>
    <eagle-select v-model="model" :queryApi="queryAPI" lazy></eagle-select>
    <span>{{ model }}</span>
  </div>
</template>

<script>
export default {
  data() {
    return {
      model: '',
    }
  },
  methods: {
    queryAPI(val) {
      return new Promise(resolve => {
        setTimeout(() => {
          resolve({
            result: [
              { label: '王五', value: 'ww' },
              { label: '赵六', value: 'zl' },
            ]
          });
        }, 1000);
      });
    },
  }
}
</script>
```

:::

</div>

<div class="code-snippet-box">

::: snippet `update`设置每次打开下拉框都保持最新数据

```html
<template>
  <div>
    <eagle-select v-model="model" :queryApi="queryAPI" :options="options" update></eagle-select>
    <span>{{ model }}</span>
  </div>
</template>

<script>
export default {
  data() {
    return {
      model: '',
      options: [
        { label: '王七', value: 'wq' },
        { label: '陈拾', value: 'cs' },
      ]
    }
  },
  methods: {
    queryAPI(val) {
      return new Promise(resolve => {
        setTimeout(() => {
          resolve({
            result: [
              { label: '王五', value: 'ww' },
              { label: '赵六', value: 'zl' },
            ]
          });
        }, 1000);
      });
    },
  }
}
</script>
```

:::

</div>

## 搜索前校验

可以通过设置`before-query`设置搜索之前的钩子，若为返回值为**false**则不执行搜索。

::: snippet 一般用于搜索前的业务逻辑校验

```html
<template>
  <eagle-select v-model="model" :options="options" :queryApi="queryAPI" :before-query="beforeQuery"></eagle-select>
</template>

<script>
export default {
  data() {
    return {
      model: '',
      options: [
        { label: '王七', value: 'wq' },
        { label: '陈拾', value: 'cs' },
      ]
    }
  },
  methods: {
    beforeQuery(query) {
      // 输入两个字符以上才执行查询
      return query.length > 2;
    },
    queryAPI(val) {
      return new Promise(resolve => {
        setTimeout(() => {
          resolve({
            result: [
              { label: '王五', value: 'ww' },
              { label: '赵六', value: 'zl' },
            ]
          });
        }, 1000);
      });
    },
  }
}
</script>
```

:::

## 可创建新条目

设置`allow-create`和`filterable`允许创建新的选项，输入内容后可以直接选择已输入的内容

<div class="code-snippet-box">

::: snippet 单选示例

```html
<template>
  <div>
    <eagle-select v-model="model" allow-create filterable>
      <el-option label="单车" value="VAN">单车</el-option>
      <el-option label="牵引车" value="TRACTOR">牵引车</el-option>
    </eagle-select>
    <span>{{ model }}</span>
  </div>
</template>

<script>
export default {
  data() {
    return {
      model: '',
    }
  } 
}
</script>
```

:::

::: snippet 多选示例

```html
<template>
  <div>
    <eagle-select v-model="model" multiple allow-create filterable>
      <el-option label="单车" value="VAN">单车</el-option>
      <el-option label="牵引车" value="TRACTOR">牵引车</el-option>
    </eagle-select>
    <span>{{ model }}</span>
  </div>
</template>

<script>
export default {
  data() {
    return {
      model: '',
    }
  } 
}
</script>
```

:::

</div>

<div class="code-snippet-box">

::: snippet 远程示例，输入创建的新项为临时项，选中后再次下拉时不会包括在选项结果中

```html
<template>
  <div>
    <eagle-select v-model="model" :options="options" :queryApi="queryAPI" allow-create filterable></eagle-select>
    <span>{{ model }}</span>
  </div>
</template>

<script>
export default {
  data() {
    return {
      model: '',
      options: [
        { label: '王七', value: 'wq' },
        { label: '陈拾', value: 'cs' },
      ]
    }
  },
  methods: {
    queryAPI(val) {
      return new Promise(resolve => {
        setTimeout(() => {
          resolve({
            result: [
              { label: '王五', value: 'ww' },
              { label: '赵六', value: 'zl' },
            ]
          });
        }, 1000);
      });
    },
  }
}
</script>
```

:::

</div>

## API

## Attribute 属性

参数|说明|类型|可选值|默认值
-|-|-|-|-
value | 值 | String, Number, Boolean, Object, Array | - | -
placeholder | 占位符 | String | - | 请选择
options | 选项列表 | Array | - | []
labelKey | 标签字段名 | String | - | label
valueKey | 值字段名 | String | - | value
searchKey | 搜索字段名 | String | - | query
size | 大小 | String | mini、small、large | mini
multiple | 多选 | Boolean | - | false
disabled | 禁用 | Boolean | - | false
clearable | 可清除 | Boolean | - | true
filterable | 可搜索 | Boolean | - | true
queryApi | 自定义接口 | Function | - | -
lazy | 初始化后懒加载数据 | Boolean | - | true
update | 点开下拉框时更新数据 | Boolean | - | false

## Events 事件

事件名称|说明|回调参数
-|-|-
change | 改变选中 | 值，选中项数据