# Schema Transfer 方案穿梭框

通过配置JSON Schema的方式快速生成一个穿梭框，与常规穿梭框不同的是，本穿梭框是表格型穿梭框。

## 基础用法

一个展示内容更多的表格形式的下拉选择器，基本配置项与`eagle-schema-page`中`schema`相同。

::: snippet `source`设置数据源, `titles`设置标题, `value-key`设置绑定值主键，默认为**id**。

```html
<template>
  <eagle-schema-transfer v-model="model" :schema="schema" :titles="titles" :source="source" value-key="id" size="small"></eagle-schema-transfer>
</template>

<script>
export default {
  data() {
    return {
      model: [],
      source: [
        { id: '0', name: '姓名0', age: 17 },
        { id: '1', name: '姓名1', age: 26 },
      ],
      titles: ['左边数据源', '右边已选中'],
      schema: {
        table: {
          items: [
            { label: '姓名', prop: 'name', minWidth: 120 },
            { label: '年龄', prop: 'age', minWidth: 120 },
            { label: '地址', prop: 'address', minWidth: 120 },
          ]
        },
      },
    }
  },
}
</script>
```

:::

## 远程搜索

数据源支持远程搜索。

::: snippet `api-search`设置查询方法，返回值格式与`eagle-schema-page`相同。

```html
<template>
  <eagle-schema-transfer v-model="model" :schema="schema" :value-filter.sync="filterModel" value-key="id" size="small" :api-search="searchAPI" auto></eagle-schema-transfer>
</template>

<script>
export default {
  data() {
    return {
      model: [],
      filterModel: { name: '' },
      schema: {
        filter: {
          items: [
            { is: 'el-input', label: '姓名', prop: 'name' },
          ]
        },
        table: {
          items: [
            { label: '姓名', prop: 'name', minWidth: 120 },
            { label: '年龄', prop: 'age', minWidth: 120 },
            { label: '地址', prop: 'address', minWidth: 120 },
          ]
        },
      },
    }
  },
  methods: {
    searchAPI(params) {
      console.log('search', params);
      return new Promise(resolve => {
        setTimeout(() => {
          const list = [
            { id: '0', name: '李饼', age: 32, address: '地址0', status: '正常' },
            { id: '1', name: '陈拾', age: 20, address: '地址1', status: '正常' },
            { id: '3', name: '王七', age: 26, address: '地址3', status: '正常' },
            { id: '4', name: '崔倍', age: 27, address: '地址4', status: '正常' },
            { id: '5', name: '孙豹', age: 38, address: '地址5', status: '正常' },
          ]
          resolve([list, 37]);
        }, 500);
      });
    },
  }
}
</script>
```

:::

## 选中表格配置

可以单独配置已选中的表格

::: snippet `schema`中设置`selected`，配置与`SchemaTable`相同。其中已选中项的表格字段可以与数据源不同，设置`choose-formatter`改变选择的数据格式。

```html
<template>
  <eagle-schema-transfer v-model="model" :schema="schema" :source="source" value-key="id" size="small" :choose-formatter="chooseFormatter"></eagle-schema-transfer>
</template>

<script>
export default {
  data() {
    return {
      model: [],
      source: [
        { id: '0', name: '姓名0', age: 17 },
        { id: '1', name: '姓名1', age: 26 },
      ],
      schema: {
        table: {
          items: [
            { label: '姓名', prop: 'name', minWidth: 120 },
            { label: '年龄', prop: 'age', minWidth: 120 },
            { label: '地址', prop: 'address', minWidth: 120 },
          ]
        },
        selected: {
          props: { border: true, editable: true },
          items: [
            { label: '姓名', prop: 'name', minWidth: 120, editable: false },
            { label: '性别', prop: 'gender', minWidth: 120, editable: false },
            { label: '民族', prop: 'ethnicity', minWidth: 120, editalways: true },
          ]
        }
      },
    }
  },
  methods: {
    chooseFormatter(row) {
      return { id: row.id, name: row.name, gender: '男', ethnicity: '汉'  };
    }
  }
}
</script>
```

:::

## 自定义插槽

同其他组件一样，可以对部分内容设置插槽

::: snippet 左侧插槽格式默认与`SchemaPage`组件相同，已选中表格的插槽以`selected-`开头

```html
<template>
  <eagle-schema-transfer v-model="model" :schema="schema" :source="source" value-key="id" size="small">
    <template #table-cell-name="{ value, size }">
      <el-tag :size="size">{{ value }}</el-tag>
    </template>
    <template #operation="{ choose }">
      <el-table-column label="新操作" width="80" align="center" fixed="right">
        <template #default="{ row, $index }">
          <div class="eagle-schema-page__table-operation">
            <el-button size="mini" @click="choose(row)">选中</el-button>
          </div>
        </template>
      </el-table-column>
    </template>
    <template #selected-cell-name="{ value, size }">
      <el-tag :size="size" type="success">{{ value }}</el-tag>
    </template>
    <template #selected-operation="{ remove }">
      <el-table-column label="新操作" width="80" align="center" fixed="right">
        <template #default="{ row, $index }">
          <div class="eagle-schema-page__table-operation">
            <el-button size="mini" @click="remove(row)">移除</el-button>
          </div>
        </template>
      </el-table-column>
    </template>
  </eagle-schema-transfer>
</template>

<script>
export default {
  data() {
    return {
      model: [],
      source: [
        { id: '0', name: '姓名0', age: 17 },
        { id: '1', name: '姓名1', age: 26 },
      ],
      schema: {
        table: {
          items: [
            { label: '姓名', prop: 'name', minWidth: 120 },
            { label: '年龄', prop: 'age', minWidth: 120 },
            { label: '地址', prop: 'address', minWidth: 120 },
          ]
        },
        selected: {
          props: { border: true, editable: true },
          items: [
            { label: '姓名', prop: 'name', minWidth: 120, editable: false },
            { label: '年龄', prop: 'age', minWidth: 120, editalways: true },
            { label: '地址', prop: 'address', minWidth: 120 },
          ]
        }
      },
    }
  },
}
</script>
```

:::

## 自定义内容

在不满足业务需求的情况下，可以设置插槽自定义左右内容

::: snippet 默认插槽`default`表示数据源，插槽`selected`表示已选中的内容

```html
<template>
  <eagle-schema-transfer v-model="model" :schema="schema" :source="source" value-key="id" size="small">
    <template #title-left>未选择 <i class="el-icon-minus"></i></template>
    <template #default="{ choose, deselect }">
      <div>
        <el-button size="mini" v-for="item in deselect(source)" @click="choose(item)">{{ item.name }}</el-button>
      </div>
    </template>
    <template #title-right>已选择 <i class="el-icon-check"></i></template>
    <template #selected="{ remove }">
      <div>
        <el-button size="mini" v-for="item in model" @click="remove(item)">{{ item.name }}</el-button>
      </div>
    </template>
  </eagle-schema-transfer>
</template>

<script>
export default {
  data() {
    return {
      model: [],
      source: [
        { id: '0', name: '姓名0', age: 17 },
        { id: '1', name: '姓名1', age: 26 },
      ],
      schema: {
        table: {
          items: [
            { label: '姓名', prop: 'name', minWidth: 120 },
            { label: '年龄', prop: 'age', minWidth: 120 },
            { label: '地址', prop: 'address', minWidth: 120 },
          ]
        },
        selected: {
          props: { border: true, editable: true },
          items: [
            { label: '姓名', prop: 'name', minWidth: 120, editable: false },
            { label: '年龄', prop: 'age', minWidth: 120, editalways: true },
            { label: '地址', prop: 'address', minWidth: 120 },
          ]
        }
      },
    }
  },
}
</script>
```

:::

## API

## Attribute 属性

参数|说明|类型|可选值|默认值
-|-|-|-|-
schema | JSON Schema配置项列表 | Array | - | []