# Schema Table 方案表格

通过配置JSON Schema的方式快速生成一个表格

## 基础用法

`schema`设置配置项，其中**props**参数与`eagle-table`组件参数相同，**items**则对应`eagle-table`组件的`columns`。

::: snippet 本质上是通过`schema`的方式实现生成一个`eagle-table`

```html
<template>
  <eagle-schema-table v-model="model" :schema="schema"></eagle-schema-table>
</template>

<script>
export default {
  data() {
    return {
      model: [
        { name: '张三', age: 16 },
        { name: '李四', age: 24 }
      ],
      schema: {
        items: [
          { label: '姓名', prop: 'name' },
          { label: '年龄', prop: 'age' },
        ]
      }
    }
  } 
}
</script>
```

:::

## 自定义列

支持自定义列的内容

::: snippet 插槽`header-列字段名`可自定义表头的内容，插槽`cell-列字段名`可自定义列单元格的内容，用法与`eagle-table`相同。

```html
<template>
  <eagle-schema-table v-model="tableData" :schema="schema">
    <template #header-age>年龄 <i class="el-icon-question"></i></template>
    <template #cell-gender="{ value }">
      <el-tag size="mini">{{ value }}</el-tag>
    </template>
  </eagle-schema-table>
</template>

<script>
export default {
  data() {
    return {
      tableData: [
        { name: '张三', age: '31', gender: '男' },
        { name: '李四', age: '27', gender: '女' },
        { name: '王五', age: '16', gender: '男' },
      ],
      schema: {
        props: { border: true },
        items: [
          { prop: 'name', label: '姓名' },
          { prop: 'age', label: '年龄' },
          { prop: 'gender', label: '性别' },
        ]
      }
    };
  },
}
</script>
```

:::

## 列渲染

除了使用插槽自定义列的内容之外，也支持直接在配置项中写渲染函数

::: snippet 配置项中的`render`可以设置对应列单元格的渲染

```html
<template>
  <eagle-schema-table v-model="tableData" :schema="schema"></eagle-schema-table>
</template>

<script>
export default {
  data() {
    return {
      tableData: [
        { name: '张三', age: '31', gender: '男', ticket: true },
        { name: '李四', age: '27', gender: '女', ticket: false },
        { name: '王五', age: '16', gender: '男', ticket: false },
      ],
      schema: {
        props: { border: true, size: 'mini' },
        items: [
          { prop: 'name', label: '姓名' },
          { prop: 'age', label: '年龄', render: (value, row, h) => h(Number(value) > 20 ? 'b' : 'span', { style: { color: Number(value) > 20 ? 'red' : 'green' } }, value) },
          { prop: 'gender', label: '性别', render: (value, row, h) => h('el-tag', { props: { size: 'mini', type: 'info' } }, value) },
          { prop: 'ticket', label: '开票', render: value => value ? '是' : '否' },
        ]
      }
    };
  },
}
</script>
```

:::

## 追加列

使用配置项时，**新增的列**则默认追加在**配置项列**之后，使用`left`插槽可在表格的最左侧插入列，顺序在**配置项列**之前

::: snippet 用法与`eagle-table`相同

```html
<template>
  <eagle-schema-table v-model="tableData" :schema="schema">
    <template #left>
      <el-table-column type="selection" width="40"></el-table-column>
      <el-table-column label="左侧的列">
        <template #default="{ $index }">
          内容 {{ $index }}
        </template>
      </el-table-column>
    </template>
    <el-table-column label="右侧的列" width="120">
      <template #default="{ $index }">
        第{{ $index + 1 }}行
      </template>
    </el-table-column>
  </eagle-schema-table>
</template>

<script>
export default {
  data() {
    return {
      tableData: [
        { name: '张三', age: '31', gender: '男' },
        { name: '李四', age: '27', gender: '女' },
        { name: '王五', age: '16', gender: '男' },
      ],
      schema: {
        props: { size: 'mini', border: true } ,
        items: [
          { prop: 'name', label: '姓名' },
          { prop: 'age', label: '年龄' },
          { prop: 'gender', label: '性别' },
        ]
      }
    };
  },
}
</script>
```

:::

## API

## Attribute 属性

参数|说明|类型|可选值|默认值
-|-|-|-|-
value | 表格数据 | Array | - | -
schema | JSON Schema配置项列表 | Array | - | []

## Events 事件

事件名称|说明|回调参数
-|-|-
selection | 表格选中 | 选中项