# Schema Select 方案选择器

通过配置JSON Schema的方式快速生成一个选择器，与常规选择器不同的是，本选择器是表格型选择器。

## 基础用法

一个展示内容更多的表格形式的下拉选择器，基本配置项与`eagle-schema-page`中`schema`相同。

::: snippet 设置`options`配置选择器数据源，`label-key`设置显示值字段，`value-key`设置绑定值字段。

```html
<template>
  <eagle-schema-select v-model="model" :options="options" :schema="schema" label-key="name" value-key="id" @change="onChange"></eagle-schema-select>
</template>

<script>
export default {
  data() {
    return {
      model: '',
      options: [
        { id: '0', name: '李饼', age: 32, address: '地址0', status: '正常' },
        { id: '1', name: '陈拾', age: 20, address: '地址1', status: '正常' },
      ],
      schema: {
        table: {
          props: {
            border: false
          },
          items: [
            { label: '姓名', prop: 'name', minWidth: 120 },
            { label: '年龄', prop: 'age', minWidth: 120 },
            { label: '地址', prop: 'address', minWidth: 120 },
          ]
        }
      },
    }
  },
  methods: {
    onChange(row) {
      console.log(row);
    }
  }
}
</script>
```

:::

## 远程搜索

配置一个接口查询远程数据。

::: snippet `api-search`设置远程搜索方法。

```html
<template>
  <div>
    <eagle-schema-select v-model="model" :schema="schema" :api-search="searchAPI" label-key="name" value-key="id"></eagle-schema-select>
    <span>{{ model }}</span>
  </div>
</template>

<script>
export default {
  data() {
    return {
      model: '',
      schema: {
        table: {
          props: {
            border: false
          },
          items: [
            { label: '姓名', prop: 'name', minWidth: 120 },
            { label: '年龄', prop: 'age', minWidth: 120 },
            { label: '地址', prop: 'address', minWidth: 120 },
          ]
        }
      },
    }
  },
  methods: {
    searchAPI(params) {
      console.log('search', params);
      return new Promise(resolve => {
        setTimeout(() => {
          const list = [
            { id: '0', name: '李饼', age: 32, address: '地址0', status: '正常' },
            { id: '1', name: '陈拾', age: 20, address: '地址1', status: '正常' },
            { id: '3', name: '王七', age: 26, address: '地址3', status: '正常' },
            { id: '4', name: '崔倍', age: 27, address: '地址4', status: '正常' },
            { id: '5', name: '孙豹', age: 38, address: '地址5', status: '正常' },
          ];
          resolve([list, 37]);
        }, 500);
      });
    },
  }
}
</script>
```

:::

## 保持输入值

若没有查询到相关结果时，允许保持当前输入值为绑定值。

::: snippet 设置`allow-create`允许创建数据源之外的新值。

```html
<template>
  <div>
    <eagle-schema-select v-model="model" :schema="schema" :api-search="searchAPI" label-key="name" value-key="id" allow-create></eagle-schema-select>
    <span>{{ model }}</span>
  </div>
</template>

<script>
export default {
  data() {
    return {
      model: '那谁',
      schema: {
        table: {
          props: {
            border: false
          },
          items: [
            { label: '姓名', prop: 'name', minWidth: 120 },
            { label: '年龄', prop: 'age', minWidth: 120 },
            { label: '地址', prop: 'address', minWidth: 120 },
          ]
        }
      },
    }
  },
  methods: {
    searchAPI(params) {
      console.log('search', params);
      return new Promise(resolve => {
        setTimeout(() => {
          const list = [
            { id: '0', name: '李饼', age: 32, address: '地址0', status: '正常' },
            { id: '1', name: '陈拾', age: 20, address: '地址1', status: '正常' },
            { id: '3', name: '王七', age: 26, address: '地址3', status: '正常' },
            { id: '4', name: '崔倍', age: 27, address: '地址4', status: '正常' },
            { id: '5', name: '孙豹', age: 38, address: '地址5', status: '正常' },
          ];
          resolve([list, 37]);
        }, 500);
      });
    },
  }
}
</script>
```

:::

## 设置默认文本

通常情况下，编辑表单时，若未加载搜索接口，则需要给定一个对应当前值的默认显示的文本

::: snippet 组件提供了一个`setLabel`可设置当前文本

```html
<template>
  <div>
    <eagle-schema-select ref="select" v-model="model" size="small" :schema="schema" :api-search="searchAPI" label-key="name" value-key="id"></eagle-schema-select>
    <span>{{ model }}</span>
  </div>
</template>

<script>
export default {
  data() {
    return {
      model: '6',
      schema: {
        table: {
          props: {
            border: false
          },
          items: [
            { label: '姓名', prop: 'name', minWidth: 120 },
            { label: '年龄', prop: 'age', minWidth: 120 },
            { label: '地址', prop: 'address', minWidth: 120 },
          ]
        }
      },
      options: [
        { id: '6', name: '张三', age: 18, address: '上海市青浦区华新镇纪鹤公路1988号', status: '禁用' },
      ]
    }
  },
  mounted() {
    setTimeout(() => {
      this.$refs.select.setLabel('李四');
    }, 3000);
  },
  methods: {
    searchAPI(params) {
      console.log('search', params);
      return new Promise(resolve => {
        setTimeout(() => {
          const list = [
            { id: '0', name: '李饼', age: 32, address: '地址0', status: '正常' },
            { id: '1', name: '陈拾', age: 20, address: '地址1', status: '正常' },
            { id: '3', name: '王七', age: 26, address: '地址3', status: '正常' },
            { id: '4', name: '崔倍', age: 27, address: '地址4', status: '正常' },
            { id: '5', name: '孙豹', age: 38, address: '地址5', status: '正常' },
          ];
          resolve([list, 37]);
        }, 500);
      });
    },
  }
}
</script>
```

:::

也可以通过设置修正数据源来修正当前显示内容

::: snippet 开启`api-search`远程搜索时，设置`options`，则作为修正数据源使用。注：修正数据源不会出现在搜索数据列表中。

```html
<template>
  <div>
    <eagle-schema-select ref="select" v-model="model" size="small" :schema="schema" :options="options" :api-search="searchAPI" label-key="name" value-key="id"></eagle-schema-select>
    <span>{{ model }}</span>
  </div>
</template>

<script>
export default {
  data() {
    return {
      model: '6',
      schema: {
        table: {
          props: {
            border: false
          },
          items: [
            { label: '姓名', prop: 'name', minWidth: 120 },
            { label: '年龄', prop: 'age', minWidth: 120 },
            { label: '地址', prop: 'address', minWidth: 120 },
          ]
        }
      },
      options: [
        { id: '6', name: '张三', age: 18, address: '上海市青浦区华新镇纪鹤公路1988号', status: '禁用' },
      ]
    }
  },
  methods: {
    searchAPI(params) {
      console.log('search', params);
      return new Promise(resolve => {
        setTimeout(() => {
          const list = [
            { id: '0', name: '李饼', age: 32, address: '地址0', status: '正常' },
            { id: '1', name: '陈拾', age: 20, address: '地址1', status: '正常' },
            { id: '3', name: '王七', age: 26, address: '地址3', status: '正常' },
            { id: '4', name: '崔倍', age: 27, address: '地址4', status: '正常' },
            { id: '5', name: '孙豹', age: 38, address: '地址5', status: '正常' },
          ];
          resolve([list, 37]);
        }, 500);
      });
    },
  }
}
</script>
```

:::

## API

## Attribute 属性

参数|说明|类型|可选值|默认值
-|-|-|-|-
schema | JSON Schema配置项列表 | Array | - | []