# Schema Page 方案页面

根据JSON Schema配置自动生成一个包含搜索、表格、表单、详情功能的页面

## 基础用法

`schema`设置配置项，其中包括`filter`、`table`、`form`三个基本schema配置，配置方式分别对应`eagle-schema-filter`、`eagle-schema-table`、`eagle-schema-form`，绑定值则分别对应`value-filter`、`value-table`、`value-form`，由于是多个双向绑定的值，所以使用`sync`修饰符来做双向绑定。

::: snippet 基础示例

```html
<template>
  <eagle-schema-page :schema="schema" :value-filter.sync="filterModel" :value-table.sync="tableModel" :value-form.sync="formModel"></eagle-schema-page>
</template>

<script>
export default {
  data() {
    return {
      schema: {
        filter: {
          items: [
            { is: 'el-input', prop: 'name', label: '姓名' },
          ]
        },
        table: {
          items: [
            { prop: 'name', label: '姓名' },
            { prop: 'age', label: '年龄' },
            { prop: 'address', label: '地址' },
            { prop: 'status', label: '状态', render: (value, row, h) => h('el-tag', { props: { size: 'mini', type: 'info' } }, value) },
          ]
        },
        form: {
          props: { labelWidth: '70px', size: 'small', span: 12 },
          items: [
            { is: 'el-input', prop: 'name', label: '姓名', rules: [{ required: true, message: '请输入姓名' }] },
            { is: 'el-input-number', prop: 'age', label: '年龄', rules: [{ required: true, message: '请输入有效年龄' }] },
            { is: 'el-input', props: { type: 'textarea' }, prop: 'address', label: '住址', span: 24 },
          ]
        },
      },
      filterModel: { name: '', age: '', gender: '', address: '' },
      formModel: { name: '', age: '', address: '' },
      tableModel: [
        { id: '0', name: '李饼', age: 32, address: '地址0', status: '正常' },
        { id: '1', name: '陈拾', age: 20, address: '地址1', status: '正常' },
        { id: '3', name: '王七', age: 26, address: '地址3', status: '正常' },
        { id: '4', name: '崔倍', age: 27, address: '地址4', status: '正常' },
        { id: '5', name: '孙豹', age: 38, address: '地址5', status: '正常' },
      ],
    }
  },
}
</script>
```

:::

## 详情入口

可以通过自定义插槽的方式，在单元格内指定详情入口。由于三个子组件均支持自定义插槽，所以在本组件中使用自定义插槽时需要加上子组件**前缀**。

::: snippet 配置表格中的详情入口可以使用`table-cell-`插槽。

```html
<template>
  <eagle-schema-page :schema="schema" :value-filter.sync="filterModel" :value-table.sync="tableModel" :value-form.sync="formModel">
    <template #table-cell-name="{ value, row, openDetail }">
      <el-link type="primary" @click="openDetail(row)">{{ value }}</el-link>
    </template>
  </eagle-schema-page>
</template>

<script>
export default {
  data() {
    return {
      schema: {
        filter: {
          items: [
            { is: 'el-input', prop: 'name', label: '姓名' },
          ]
        },
        table: {
          items: [
            { prop: 'name', label: '姓名' },
            { prop: 'age', label: '年龄' },
            { prop: 'address', label: '地址' },
            { prop: 'status', label: '状态', render: (value, row, h) => h('el-tag', { props: { size: 'mini', type: 'info' } }, value) },
          ]
        },
        form: {
          props: { labelWidth: '70px', size: 'small', span: 12 },
          items: [
            { is: 'el-input', prop: 'name', label: '姓名', rules: [{ required: true, message: '请输入姓名' }] },
            { is: 'el-input-number', prop: 'age', label: '年龄', rules: [{ required: true, message: '请输入有效年龄' }] },
            { is: 'el-input', props: { type: 'textarea' }, prop: 'address', label: '住址', span: 24 },
          ]
        },
      },
      filterModel: { name: '', age: '', gender: '', address: '' },
      formModel: { name: '', age: '', address: '' },
      tableModel: [
        { id: '0', name: '李饼', age: 32, address: '地址0', status: '正常' },
        { id: '1', name: '陈拾', age: 20, address: '地址1', status: '正常' },
        { id: '3', name: '王七', age: 26, address: '地址3', status: '正常' },
        { id: '4', name: '崔倍', age: 27, address: '地址4', status: '正常' },
        { id: '5', name: '孙豹', age: 38, address: '地址5', status: '正常' },
      ],
    }
  },
}
</script>
```

:::

## 对接接口

本组件预置了增删改查逻辑，因此分别对应`api-search`、`api-new`、`api-edit`、`api-get`、`api-delete`五个基本接口。

::: snippet 接口格式为返回一个**Promise**对象的**Function**。其中，`api-search`的执行结果必须是[分页数据, 数据总数]的格式，`api-get`的执行结果必须与`valur-form`相对应，`api-new`、`api-edit`、`api-delete`保持默认的**Promise**的resolve或reject逻辑即可，详情见示例。

```html
<template>
  <eagle-schema-page
    :schema="schema"
    :value-filter.sync="filterModel"
    :value-form.sync="formModel"
    :api-search="searchAPI"
    :api-get="getAPI"
    :api-delete="deleteAPI"
    :api-new="newAPI"
    :api-edit="editAPI"
    size="small"
  >
    <template #table-cell-name="{ value, row, openDetail }">
      <el-link type="primary" @click="openDetail(row)">{{ value }}</el-link>
    </template>
  </eagle-schema-page>
</template>

<script>
export default {
  data() {
    return {
      schema: {
        auto: true,
        filter: {
          items: [
            { is: 'el-input', prop: 'name', label: '姓名' },
          ]
        },
        table: {
          items: [
            { prop: 'name', label: '姓名' },
            { prop: 'age', label: '年龄' },
            { prop: 'address', label: '地址' },
            { prop: 'status', label: '状态', render: (value, row, h) => h('el-tag', { props: { size: 'mini', type: 'info' } }, value) },
          ]
        },
        form: {
          props: { labelWidth: '70px', size: 'small', span: 12 },
          items: [
            { is: 'el-input', prop: 'name', label: '姓名', rules: [{ required: true, message: '请输入姓名' }] },
            { is: 'el-input-number', prop: 'age', label: '年龄', rules: [{ required: true, message: '请输入有效年龄' }] },
            { is: 'el-input', props: { type: 'textarea' }, prop: 'address', label: '住址', span: 24 },
          ]
        },
      },
      filterModel: { name: '', age: '', gender: '', address: '' },
      formModel: { name: '', age: '', address: '' },
    }
  },
  methods: {
    searchAPI(params) {
      console.log('search', params);
      return new Promise(resolve => {
        setTimeout(() => {
          const list = [
            { id: '0', name: '李饼', age: 32, address: '地址0', status: '正常' },
            { id: '1', name: '陈拾', age: 20, address: '地址1', status: '正常' },
            { id: '3', name: '王七', age: 26, address: '地址3', status: '正常' },
            { id: '4', name: '崔倍', age: 27, address: '地址4', status: '正常' },
            { id: '5', name: '孙豹', age: 38, address: '地址5', status: '正常' },
          ]
          resolve([list, 37]);
        }, 500);
      });
    },
    getAPI(row) {
      console.log('get', row);
      return new Promise((resolve, reject) => {
        setTimeout(() => {
          resolve({ ...row, name: `[${row.name}]` });
        }, 1500);
      });
    },
    newAPI(model) {
      console.log('new', model);
      return new Promise((resolve, reject) => {
        setTimeout(() => {
          resolve();
        }, 1500);
      });
    },
    editAPI(model) {
      console.log('edit', model);
      return new Promise((resolve, reject) => {
        setTimeout(() => {
          reject();
        }, 1500);
      });
    },
    deleteAPI(selection) {
      console.log('delete', selection);
      return new Promise((resolve, reject) => {
        setTimeout(() => {
          resolve();
        }, 1500);
      });
    }
  }
}
</script>
```

:::

## 详情接口

由于可能出现详情与表单不同的情况，因此本组件提供了`value-detail`属性和`api-detail`接口可独立维护详情页面，若详情表单项也不同，则可以在`schema`中配置`detail`来设置。

::: snippet 若没有详情绑定值属性和接口，则默认以表单的值为准。

```html
<template>
  <eagle-schema-page
    :schema="schema"
    :value-filter.sync="filterModel"
    :value-form.sync="formModel"
    :value-detail.sync="detailModel"
    :api-search="searchAPI"
    :api-get="getAPI"
    :api-detail="detailAPI"
    :api-delete="deleteAPI"
    :api-new="newAPI"
    :api-edit="editAPI"
  >
    <template #table-cell-name="{ value, row, openDetail }">
      <el-link type="primary" @click="openDetail(row)">{{ value }}</el-link>
    </template>
    <template #detail-packages="{ value }">
      <el-tag v-for="item in value" size="mini" type="info" style="margin-right: 10px">{{ item }}</el-tag>
    </template>
  </eagle-schema-page>
</template>

<script>
export default {
  data() {
    return {
      schema: {
        auto: true,
        filter: {
          items: [
            { is: 'el-input', prop: 'name', label: '姓名' },
          ]
        },
        table: {
          items: [
            { prop: 'name', label: '姓名' },
            { prop: 'age', label: '年龄' },
            { prop: 'address', label: '地址' },
            { prop: 'status', label: '状态', render: (value, row, h) => h('el-tag', { props: { size: 'mini', type: 'info' } }, value) },
          ]
        },
        form: {
          props: { labelWidth: '70px', size: 'small', span: 12 },
          items: [
            { is: 'el-input', prop: 'name', label: '姓名', rules: [{ required: true, message: '请输入姓名' }] },
            { is: 'el-input-number', prop: 'age', label: '年龄', rules: [{ required: true, message: '请输入有效年龄' }] },
            { is: 'el-input', props: { type: 'textarea' }, prop: 'address', label: '住址', span: 24 },
          ]
        },
        detail: {
          props: { labelWidth: '70px', size: 'small', span: 12 },
          items: [
            { prop: 'name', label: '姓名' },
            { prop: 'age', label: '年龄' },
            { props: { type: 'textarea' }, prop: 'address', label: '住址' },
            { prop: 'packages', label: '包裹', span: 24 }
          ]
        }
      },
      filterModel: { name: '', age: '', gender: '', address: '' },
      formModel: { name: '', age: '', address: '' },
      detailModel: { name: '', age: '', address: '', packages: [] },
    }
  },
  methods: {
    searchAPI(params) {
      console.log('search', params);
      return new Promise(resolve => {
        setTimeout(() => {
          const list = [
            { id: '0', name: '李饼', age: 32, address: '地址0', status: '正常' },
            { id: '1', name: '陈拾', age: 20, address: '地址1', status: '正常' },
            { id: '3', name: '王七', age: 26, address: '地址3', status: '正常' },
            { id: '4', name: '崔倍', age: 27, address: '地址4', status: '正常' },
            { id: '5', name: '孙豹', age: 38, address: '地址5', status: '正常' },
          ]
          resolve([list, 37]);
        }, 500);
      });
    },
    getAPI(row) {
      console.log('get', row);
      return new Promise((resolve, reject) => {
        setTimeout(() => {
          resolve({ ...row, name: `[${row.name}]` });
        }, 1500);
      });
    },
    detailAPI(row) {
      console.log('detail', row);
      return new Promise((resolve, reject) => {
        setTimeout(() => {
          resolve({ ...row, packages: ['手机', '电脑'], address: '上海市青浦区华新镇纪鹤公路1988号' });
        }, 1500);
      });
    },
    newAPI(model) {
      console.log('new', model);
      return new Promise((resolve, reject) => {
        setTimeout(() => {
          resolve();
        }, 1500);
      });
    },
    editAPI(model) {
      console.log('edit', model);
      return new Promise((resolve, reject) => {
        setTimeout(() => {
          reject();
        }, 1500);
      });
    },
    deleteAPI(selection) {
      console.log('delete', selection);
      return new Promise((resolve, reject) => {
        setTimeout(() => {
          resolve();
        }, 1500);
      });
    }
  }
}
</script>
```

:::

## 自定义弹窗

除了本组件内置的`new`、`edit`、`detail`三种弹出框模式之外，还可以通过任意插槽打开任意自定义弹出框。也支持重新定义原有的三种弹框，同时也需要重新自定义表单校验和提交等逻辑。

::: snippet 插槽提供`openDialog`打开弹出框方法，参数类型为(type: 弹出框类型, title: 弹出框标题, config: 弹出框配置)，弹出框主体通过`dialog-`插槽定义。`closeDialog`为关闭弹出框。

```html
<template>
  <eagle-schema-page :schema="schema" :value-table.sync="tableModel">
    <template #action-button="{ size, openDialog }">
      <el-button :size="size" @click="openDialog('bill', '账单', { width: '70%' })">账单</el-button>
    </template>
    <template #operation-button="{ openDialog, row }">
      <el-button type="text" @click="openDialog('load', `配置-${row.name}`, { width: '400px' })">配载</el-button>
    </template>
    <template #table-cell-name="{ value, row, openDetail }">
      <el-link type="primary" @click="openDetail(row)">{{ value }}</el-link>
    </template>
    <template #dialog-bill="{ closeDialog }">
      <eagle-schema-table v-model="billData" :schema="billSchema"></eagle-schema-table>
      <div style="text-align: center; margin-top: 20px">
        <el-button plain @click="closeDialog">关闭</el-button>
      </div>
    </template>
    <template #dialog-load="{ closeDialog }">
      <el-alert title="这里是一段自定义信息" type="error" show-icon style="margin-bottom: 20px"></el-alert>
      <eagle-schema-form v-model="loadModel" :schema="loadSchema"></eagle-schema-form>
      <el-button type="primary" @click="closeDialog">关闭弹出框</el-button>
    </template>
    <template #dialog-new="{ closeDialog }">
      <el-alert title="这里是自定义新增弹窗" type="success" show-icon style="margin-bottom: 20px"></el-alert>
      <el-button plain @click="closeDialog">关闭</el-button>
    </template>
    <template #dialog-edit="{ closeDialog }">
      <el-alert title="这里是自定义编辑弹窗" type="warning" show-icon style="margin-bottom: 20px"></el-alert>
      <el-button plain @click="closeDialog">关闭</el-button>
    </template>
    <template #dialog-detail="{ closeDialog }">
      <el-alert title="这里是自定义详情弹窗" type="info" show-icon style="margin-bottom: 20px"></el-alert>
      <el-button plain @click="closeDialog">关闭</el-button>
    </template>
  </eagle-schema-page>
</template>

<script>
export default {
  data() {
    return {
      schema: {
        filter: {
          items: [
            { is: 'el-input', prop: 'name', label: '姓名' },
          ]
        },
        table: {
          items: [
            { prop: 'name', label: '姓名' },
            { prop: 'age', label: '年龄' },
            { prop: 'address', label: '地址' },
            { prop: 'status', label: '状态', render: (value, row, h) => h('el-tag', { props: { size: 'mini', type: 'info' } }, value) },
          ]
        },
        form: {
          props: { labelWidth: '70px', size: 'small', span: 12 },
          items: [
            { is: 'el-input', prop: 'name', label: '姓名', rules: [{ required: true, message: '请输入姓名' }] },
            { is: 'el-input-number', prop: 'age', label: '年龄', rules: [{ required: true, message: '请输入有效年龄' }] },
            { is: 'el-input', props: { type: 'textarea' }, prop: 'address', label: '住址', span: 24 },
          ]
        },
        operation: { width: 120 }
      },
      tableModel: [
        { id: '0', name: '李饼', age: 32, address: '地址0', status: '正常' },
        { id: '1', name: '陈拾', age: 20, address: '地址1', status: '正常' },
        { id: '3', name: '王七', age: 26, address: '地址3', status: '正常' },
        { id: '4', name: '崔倍', age: 27, address: '地址4', status: '正常' },
        { id: '5', name: '孙豹', age: 38, address: '地址5', status: '正常' },
      ],
      loadModel: {
        name: '',
        count: 1,
        packages: []
      },
      loadSchema: {
        props: { 'label-width': '70px', size: 'small' },
        items: [
          { is: 'el-input', prop: 'name', label: '名称' },
          { is: 'el-input-number', prop: 'count', label: '数量' },
          {
            is: 'el-checkbox-group',
            prop: 'packages',
            label: '包裹',
            children: [
              { is: 'el-checkbox', props: { label: '零食' } },
              { is: 'el-checkbox', props: { label: '手机' } },
              { is: 'el-checkbox', props: { label: '电脑' } },
            ],
          },
        ]
      },
      billData: [
        { billno: 'B20210401000001', amount: '18750' },
        { billno: 'B20210401000002', amount: '637' },
      ],
      billSchema: {
        items: [
          { label: '单号', prop: 'billno' },
          { label: '金额', prop: 'amount' },
        ]
      }
    }
  },
}
</script>
```

:::

## 弹窗类型

弹出框组件默认为`el-dialog`，使用自定义弹窗时，可以设置为`el-drawer`。

::: snippet 通过`openDialog`的config参数配置`is: 'el-drawer'`即可改为抽屉式弹窗，`dialog-xxx-footer`可以设置抽屉固定的footer

```html
<template>
  <eagle-schema-page :schema="schema" :value-table.sync="tableModel">
    <template #action-button="{ size, openDialog }">
      <el-button :size="size" @click="openDialog('bill', '账单', { is: 'el-drawer', width: '70%' })">账单</el-button>
    </template>
    <template #operation-button="{ openDialog, row }">
      <el-button type="text" @click="openDialog('load', `配置-${row.name}`, { is: 'el-drawer', width: '400px' })">配载</el-button>
    </template>
    <template #table-cell-name="{ value, row, openDetail }">
      <el-link type="primary" @click="openDetail(row)">{{ value }}</el-link>
    </template>
    <template #dialog-bill="{ closeDialog }">
      <div style="background: #f5f5f5; height: 90vh; display: flex; align-items: center; justify-content: center">一段很长的内容</div>
      <eagle-schema-table v-model="billData" :schema="billSchema"></eagle-schema-table>
    </template>
    <template #dialog-bill-footer="{ closeDialog }">
      <el-button plain @click="closeDialog">关闭</el-button>
    </template>
    <template #dialog-load="{ closeDialog }">
      <el-alert title="这里是一段自定义信息" type="error" show-icon style="margin-bottom: 20px"></el-alert>
      <eagle-schema-form v-model="loadModel" :schema="loadSchema"></eagle-schema-form>
      <el-button type="primary" @click="closeDialog">关闭弹出框</el-button>
    </template>
  </eagle-schema-page>
</template>

<script>
export default {
  data() {
    return {
      schema: {
        filter: {
          items: [
            { is: 'el-input', prop: 'name', label: '姓名' },
          ]
        },
        table: {
          items: [
            { prop: 'name', label: '姓名' },
            { prop: 'age', label: '年龄' },
            { prop: 'address', label: '地址' },
            { prop: 'status', label: '状态', render: (value, row, h) => h('el-tag', { props: { size: 'mini', type: 'info' } }, value) },
          ]
        },
        form: {
          props: { labelWidth: '70px', size: 'small', span: 12 },
          items: [
            { is: 'el-input', prop: 'name', label: '姓名', rules: [{ required: true, message: '请输入姓名' }] },
            { is: 'el-input-number', prop: 'age', label: '年龄', rules: [{ required: true, message: '请输入有效年龄' }] },
            { is: 'el-input', props: { type: 'textarea' }, prop: 'address', label: '住址', span: 24 },
          ]
        },
        operation: { width: 120 }
      },
      tableModel: [
        { id: '0', name: '李饼', age: 32, address: '地址0', status: '正常' },
        { id: '1', name: '陈拾', age: 20, address: '地址1', status: '正常' },
        { id: '3', name: '王七', age: 26, address: '地址3', status: '正常' },
        { id: '4', name: '崔倍', age: 27, address: '地址4', status: '正常' },
        { id: '5', name: '孙豹', age: 38, address: '地址5', status: '正常' },
      ],
      loadModel: {
        name: '',
        count: 1,
        packages: []
      },
      loadSchema: {
        props: { 'label-width': '70px', size: 'small' },
        items: [
          { is: 'el-input', prop: 'name', label: '名称' },
          { is: 'el-input-number', prop: 'count', label: '数量' },
          {
            is: 'el-checkbox-group',
            prop: 'packages',
            label: '包裹',
            children: [
              { is: 'el-checkbox', props: { label: '零食' } },
              { is: 'el-checkbox', props: { label: '手机' } },
              { is: 'el-checkbox', props: { label: '电脑' } },
            ],
          },
        ]
      },
      billData: [
        { billno: 'B20210401000001', amount: '18750' },
        { billno: 'B20210401000002', amount: '637' },
      ],
      billSchema: {
        items: [
          { label: '单号', prop: 'billno' },
          { label: '金额', prop: 'amount' },
        ]
      }
    }
  },
}
</script>
```

:::

## 按钮权限

本组件不包含自定义业务逻辑，因此配置项不包含权限判断，如果需要按钮的权限判断，可以通过`action`插槽和`operation`插槽将渲染逻辑暴露在视图模板中，然后进行自定义判断。

::: snippet 本示例项目中没有`v-permission`等自定义权限指令，使用时根据实际情况在对应的按钮加上判断即可

```html
<template>
  <eagle-schema-page :schema="schema" :value-filter.sync="filterModel" :value-table.sync="tableModel" :value-form.sync="formModel">
    <template #action="{ size, selection, openNew, onDeleteMultiple }">
      <el-button :size="size" type="primary" @click="openNew">新增</el-button>
      <el-button :size="size" plain :disabled="selection.length === 0" @click="onDeleteMultiple(selection)">删除</el-button>
    </template>
    <template #operation="{ openEdit, onDelete }">
      <el-table-column label="操作" width="90" align="center">
        <template #default="{ row, column, $index }">
          <div class="eagle-schema-page__table-operation">
            <el-button type="text" icon="el-icon-edit" title="编辑" @click="openEdit(row)"></el-button>
            <el-popconfirm confirm-button-text="确定" cancel-button-text="取消" title="确定删除吗？" placement="top" @confirm="onDelete([row])">
              <el-button slot="reference" type="text" icon="el-icon-delete" title="删除"></el-button>
            </el-popconfirm>
          </div>
        </template>
      </el-table-column>
    </template>
  </eagle-schema-page>
</template>

<script>
export default {
  data() {
    return {
      schema: {
        filter: {
          items: [
            { is: 'el-input', prop: 'name', label: '姓名' },
          ]
        },
        table: {
          items: [
            { prop: 'name', label: '姓名' },
            { prop: 'age', label: '年龄' },
            { prop: 'address', label: '地址' },
            { prop: 'status', label: '状态', render: (value, row, h) => h('el-tag', { props: { size: 'mini', type: 'info' } }, value) },
          ]
        },
        form: {
          props: { labelWidth: '70px', size: 'small', span: 12 },
          items: [
            { is: 'el-input', prop: 'name', label: '姓名', rules: [{ required: true, message: '请输入姓名' }] },
            { is: 'el-input-number', prop: 'age', label: '年龄', rules: [{ required: true, message: '请输入有效年龄' }] },
            { is: 'el-input', props: { type: 'textarea' }, prop: 'address', label: '住址', span: 24 },
          ]
        },
      },
      filterModel: { name: '', age: '', gender: '', address: '' },
      formModel: { name: '', age: '', address: '' },
      tableModel: [
        { id: '0', name: '李饼', age: 32, address: '地址0', status: '正常' },
        { id: '1', name: '陈拾', age: 20, address: '地址1', status: '正常' },
        { id: '3', name: '王七', age: 26, address: '地址3', status: '正常' },
        { id: '4', name: '崔倍', age: 27, address: '地址4', status: '正常' },
        { id: '5', name: '孙豹', age: 38, address: '地址5', status: '正常' },
      ],
    }
  },
}
</script>
```

:::

## 静态表格

设置`datagrid`将组建转化为静态表格，即不包含增删改查API的可编辑表格，不分页。

::: snippet 基本参数和基础用法相同

```html
<template>
  <eagle-schema-page :schema="schema" :value-table.sync="tableModel" :value-form.sync="formModel" datagrid :tips="false"></eagle-schema-page>
</template>

<script>
export default {
  data() {
    return {
      schema: {
        filter: false,
        table: {
          items: [
            { prop: 'name', label: '姓名' },
            { prop: 'age', label: '年龄' },
            { prop: 'address', label: '地址' },
            { prop: 'status', label: '状态', render: (value, row, h) => h('el-tag', { props: { size: 'mini', type: 'info' } }, value) },
          ]
        },
        form: {
          props: { labelWidth: '70px', size: 'small', span: 12 },
          items: [
            { is: 'el-input', prop: 'name', label: '姓名', rules: [{ required: true, message: '请输入姓名' }] },
            { is: 'el-input-number', prop: 'age', label: '年龄', rules: [{ required: true, message: '请输入有效年龄' }] },
            { is: 'el-input', props: { type: 'textarea' }, prop: 'address', label: '住址', span: 24 },
          ]
        },
      },
      formModel: { name: '', age: '', address: '' },
      tableModel: [
        { id: '0', name: '李饼', age: 32, address: '地址0', status: '正常' },
        { id: '1', name: '陈拾', age: 20, address: '地址1', status: '正常' },
        { id: '3', name: '王七', age: 26, address: '地址3', status: '正常' },
        { id: '4', name: '崔倍', age: 27, address: '地址4', status: '正常' },
        { id: '5', name: '孙豹', age: 38, address: '地址5', status: '正常' },
      ],
    }
  },
}
</script>
```

:::

## API

## Attribute 属性

参数|说明|类型|可选值|默认值
-|-|-|-|-
schema | JSON Schema配置项列表 | Array | - | []

## Schema 参数

参数|说明|类型|可选值|默认值
-|-|-|-|-
filter | 搜索表单，false表示不显示，Object表示Schema | Object, Boolean | - | false
action | 操作栏显示状态 | Boolean | - | true
table | 表格，false表示不显示，Object表示Schema | Object, Boolean | - | false
operation | 操作列，false表示不显示，Object表示操作栏配置 | Object, Boolean | - | {}
pagination | 分页器，false表示不显示，Object表示分页器配置 | Object, Boolean | - | {}
form | 表单，false表示不显示，Object表示Schema | Object, Boolean | - | false
action | 表单 | Boolean | - | true
selection | 可选择 | Boolean | - | true