# Schema Filter 方案筛选

通过配置JSON Schema的方式快速生成一个筛选表单

## 基础用法

`schema`设置配置项，基本参数与`eagle-schema-form`相同；不同的是，由于本组件包含了展开状态，配置项的显示隐藏需要统一控制，因此本组件中不包含配置项的显隐逻辑。

::: snippet `schema`设置配置项，`loading`设置加载状态

```html
<template>
  <eagle-schema-filter v-model="form" :schema="schema" :loading="loading" @search="onSearch" @reset="onReset"></eagle-schema-filter>
</template>

<script>
export default {
  data() {
    return {
      form: {
        name: '',
        age: '',
        gender: '',
      },
      schema: {
        items: [
          { is: 'el-input', prop: 'name', label: '姓名' },
          { is: 'el-input', prop: 'age', label: '年龄' },
          { is: 'el-input', prop: 'gender', label: '性别' },
        ]
      },
      loading: false
    };
  },
  methods: {
    onSearch(model) {
      this.loading = true;
      console.log(model);
      setTimeout(() => {
        this.loading = false;
      }, 1500);
    },
    onReset() {
      console.log('reset');
    }
  }
};
</script>
```

:::

::: snippet 默认显示数量为`3`，超过则会显示展开按钮

```html
<template>
  <eagle-schema-filter v-model="form" :schema="schema"></eagle-schema-filter>
</template>

<script>
export default {
  data() {
    return {
      form: {
        name: '',
        age: '',
        gender: '',
      },
      schema: {
        props: { size: 'small' },
        items: [
          { is: 'el-input', prop: 'name', label: '姓名' },
          { is: 'el-input', prop: 'age', label: '年龄' },
          { is: 'el-input', prop: 'gender', label: '性别' },
          { is: 'el-input', prop: 'address', label: '地址' },
          { is: 'el-input', prop: 'package', label: '包裹' },
        ]
      },
    };
  },
};
</script>
```

:::

## 默认展示数量

常见的业务场景下，经常会出现多个筛选条件的情况，可以默认展示多行的搜索项。

::: snippet `display`设置默认展示的搜索项数量，控制按钮栏占位会根据每行剩余搜索项数量自动计算。

```html
<template>
  <eagle-schema-filter v-model="form" :schema="schema" :display="7"></eagle-schema-filter>
</template>

<script>
export default {
  data() {
    return {
      form: {
        name: '',
        age: '',
        gender: '',
      },
      schema: {
        props: { size: 'small' },
        items: [
          { is: 'el-input', prop: 'name', label: '姓名' },
          { is: 'el-input', prop: 'age', label: '年龄' },
          { is: 'el-input', prop: 'gender', label: '性别' },
          { is: 'el-input', prop: 'item1', label: '搜索项1' },
          { is: 'el-input', prop: 'item2', label: '搜索项2' },
          { is: 'el-input', prop: 'item3', label: '搜索项3' },
          { is: 'el-input', prop: 'item4', label: '搜索项4' },
          { is: 'el-input', prop: 'item5', label: '搜索项5' },
          { is: 'el-input', prop: 'item6', label: '搜索项6' },
        ]
      },
      loading: false
    };
  },
  methods: {
    onSearch(model) {
      this.loading = true;
      console.log(model);
      setTimeout(() => {
        this.loading = false;
      }, 1500);
    },
    onReset() {
      console.log('reset');
    }
  }
};
</script>
```

:::

## 操作栏占位

某些业务场景下，搜索栏不一定每一项的占位都相等，这种情况下已经不便于自动计算准确的占位了，此时可以手动设置展开和收起时的占位。

::: snippet `collapsed-span`设置操作栏展开状态的占位，`uncollapsed-span`设置操作栏收起状态的占位。

```html
<template>
  <eagle-schema-filter v-model="form" :schema="schema" :display="6" :collapsed-span="12" :uncollapsed-span="6"></eagle-schema-filter>
</template>

<script>
export default {
  data() {
    return {
      form: {
        name: '',
        age: '',
        gender: '',
      },
      schema: {
        props: { size: 'small' },
        items: [
          { is: 'el-input', prop: 'name', label: '姓名' },
          { is: 'el-input', prop: 'age', label: '年龄' },
          { is: 'el-input', prop: 'gender', label: '性别', span: 12 },
          { is: 'el-input', prop: 'item1', label: '搜索项1' },
          { is: 'el-input', prop: 'item2', label: '搜索项2' },
          { is: 'el-input', prop: 'item3', label: '搜索项3' },
          { is: 'el-input', prop: 'item4', label: '搜索项4' },
          { is: 'el-input', prop: 'item5', label: '搜索项5' },
          { is: 'el-input', prop: 'item6', label: '搜索项6' },
        ]
      },
      loading: false
    };
  },
  methods: {
    onSearch(model) {
      this.loading = true;
      console.log(model);
      setTimeout(() => {
        this.loading = false;
      }, 1500);
    },
    onReset() {
      console.log('reset');
    }
  }
};
</script>
```

:::

## 自定义操作栏

特殊业务场景下，可以自定义操作栏

::: snippet `operation`插槽替换默认操作栏

```html
<template>
  <eagle-schema-filter v-model="form" :schema="schema" :display="2" :loading="loading" @search="onSearch" @reset="onReset">
    <template #operation="{ search, reset, collapse, collapsed, loading }">
      <el-button-group round style="display: flex; justify-content: flex-end">
        <el-button round type="primary" @click="search" :loading="loading" icon="el-icon-search">查询</el-button>
        <el-button round @click="reset">重置</el-button>
        <el-button round @click="onClick">自定义按钮</el-button>
        <el-button round @click="collapse">{{ collapsed ? '收起' : '展开' }}</el-button>
      </el-button-group>
    </template>
  </eagle-schema-filter>
</template>

<script>
export default {
  data() {
    return {
      form: {
        name: '',
        age: '',
        gender: '',
      },
      schema: {
        props: { size: 'small' },
        items: [
          { is: 'el-input', prop: 'name', label: '姓名' },
          { is: 'el-input', prop: 'age', label: '年龄' },
          { is: 'el-input', prop: 'gender', label: '性别' },
          { is: 'el-input', prop: 'address', label: '地址' },
          { is: 'el-input', prop: 'address', label: '地址' },
        ]
      },
      loading: false,
    };
  },
  methods: {
    onSearch(model) {
      this.loading = true;
      console.log(model);
      setTimeout(() => {
        this.loading = false;
      }, 1500);
    },
    onReset() {
      console.log('reset');
    },
    onClick() {
      console.log('click');
    }
  }
};
</script>
```

:::

## API

## Attribute 属性

参数|说明|类型|可选值|默认值
-|-|-|-|-
value | 值 | Object | - | {}
schema | JSON Schema配置项列表 | Object | - | {}
size | 大小 | String | - | -
loading | 加载状态 | Boolean | - | false
display | 默认收起时显示数量 | Number | - | 3
span | 子项占位 | Number | - | 6
collapsedSpan | 展开时操作栏占位，默认自动计算，特殊情况下可手动设置 | Boolean | - | -
uncollapsedSpan | 收起时操作栏占位，默认自动计算，特殊情况下可手动设置 | Boolean | - | -

## Events 事件

事件名称|说明|回调参数
-|-|-
input | 表单值变化 | model
search | 搜索 | model
reset | 重置 | -