# Form 表单

拓展ElementUI的`el-form`，结合`el-form`、`el-row`、`el-col`的基本特性，支持子项默认占位。

## 基础用法

基本参数与ElementUI的`el-form`相同。

::: snippet 设置`span`调整子项默认占位宽度

```html
<template>
  <eagle-form ref="form" :model="model" :rules="rules" label-width="80px" size="small" span="12">
    <eagle-form-item label="姓名" prop="name">
      <el-input v-model="model.name"></el-input>
    </eagle-form-item>
    <eagle-form-item label="年龄" prop="age">
      <el-input v-model="model.age"></el-input>
    </eagle-form-item>
    <eagle-form-item label="性别" prop="gender">
      <eagle-select v-model="model.gender" :options="[{ label: '男', value: '男' }, { label: '女', value: '女' }]"></eagle-select>
    </eagle-form-item>
    <eagle-form-item span="24" label="详细地址" prop="address">
      <el-input v-model="model.address" type="textarea"></el-input>
    </eagle-form-item>
    <eagle-form-item>
      <el-button type="primary" @click="onSubmit">确定</el-button>
      <el-button @click="onReset">重置</el-button>
    </eagle-form-item>
  </eagle-form>
</template>

<script>
export default {
  data() {
    return {
      model: { name: '张三', age: '31', gender: '男', address: '' },
      rules: {
        name: [{ required: true, message: '请输入姓名' }]
      }
    };
  },
  methods: {
    onSubmit() {
      this.$refs.form.validate(valid => {
        if (valid) {
          console.log(this.model);
        }
      });
    },
    onReset() {
      this.$refs.form.resetFields();
    }
  }
}
</script>
```

:::

## 极简用法

设置当前表单下表单项的默认组件

::: snippet 设置`item-component`指定默认组件

```html
<template>
  <eagle-form ref="form" :model="model" :rules="rules" label-width="80px" size="small" span="12" item-component="el-input">
    <eagle-form-item label="姓名" prop="name" v-model="model.name"></eagle-form-item>
    <eagle-form-item label="年龄" prop="age" v-model="model.age"></eagle-form-item>
    <eagle-form-item label="性别" prop="gender" v-model="model.gender"></eagle-form-item>
    <eagle-form-item label="详细地址" span="24" prop="address" type="textarea" v-model="model.address"></eagle-form-item>
    <eagle-form-item>
      <el-button type="primary" @click="onSubmit">确定</el-button>
      <el-button @click="onReset">重置</el-button>
    </eagle-form-item>
  </eagle-form>
</template>

<script>
export default {
  data() {
    return {
      model: { name: '张三', age: '31', gender: '男', address: '' },
      rules: {
        name: [{ required: true, message: '请输入姓名' }]
      }
    }
  },
  methods: {
    onSubmit() {
      this.$refs.form.validate(valid => {
        if (valid) {
          console.log(this.model);
        }
      });
    },
    onReset() {
      this.$refs.form.resetFields();
    }
  }
}
</script>
```

:::

## 详情展示

不使用表单组件时也可用于做详情信息展示

::: snippet 支持`value`或任意组件

```html
<template>
  <eagle-form label-width="100px" size="mini" span="8">
    <eagle-form-item label="户主姓名" :value="model.name" required></eagle-form-item>
    <eagle-form-item label="年龄" :value="model.age"></eagle-form-item>
    <eagle-form-item label="性别" :value="model.gender"></eagle-form-item>
    <eagle-form-item label="详细地址" span="24">
      <el-tag size="mini" type="info">{{ model.address }}</el-tag>
      <template #label>
        <el-tooltip content="地址信息务必准确" placement="top" effect="light">
          <i class="el-icon-warning-outline"></i>
        </el-tooltip>
        <span>详细地址</span>
      </template>
    </eagle-form-item>
    <eagle-form-item label-width="0" span="24">
      <el-table :data="model.list" size="mini">
        <el-table-column label="缴费时间" prop="date"></el-table-column>
        <el-table-column label="缴费类型" prop="type"></el-table-column>
        <el-table-column label="缴费金额" prop="amount" align="right"></el-table-column>
      </el-table>
    </eagle-form-item>
  </eagle-form>
</template>

<script>
export default {
  data() {
    return {
      model: {
        name: '张三',
        age: '31',
        gender: '男',
        address: '上海市青浦区华新镇纪鹤公路1988号',
        list: [
          { type: '水费', amount: '60.00', date: '2021-01-12' },
          { type: '电费', amount: '127.50', date: '2021-01-23' }
        ],
      },
    }
  },
}
</script>
```

:::

## API

## Attribute 属性

参数|说明|类型|可选值|默认值
-|-|-|-|-
value | 值 | Object | - | -

## Events 事件

事件名称|说明|回调参数
-|-|-
input | 表单值变化 | 表单model