# Form Item 表单项

使用Element UI的项目通常会出现大量的`el-col`和`el-form-item`配合使用而导致代码臃肿，因此本组件将二者合并为一个组件，可与原组件兼容。

> 注意：非`eagle-form`组件下使用时，需要在外层加上`el-row`

## 基础用法

::: snippet 用法与ElementUI相同

```html
<template>
  <el-form :model="model" :rules="rules" label-width="80px" size="small">
    <el-row>
      <!-- 新组件示例 -->
      <eagle-form-item :span="12" label="姓名" prop="name">
        <el-input v-model="model.name"></el-input>
      </eagle-form-item>
      <eagle-form-item :span="12" label="年龄" prop="age">
        <el-input v-model="model.age"></el-input>
      </eagle-form-item>
      <!-- 原组件示例 -->
      <el-col :span="12">
        <el-form-item label="性别" prop="gender">
          <el-input v-model="model.gender"></el-input>
        </el-form-item>
      </el-col>
    </el-row>
  </el-form>
</template>

<script>
export default {
  data() {
    return {
      model: { name: '', age: '', gender: '' },
      rules: {
        name: [{ required: true, message: '请输入姓名' }, { pattern: /^\d{16,19}$/, message: '请输入正确的银行卡号' },]
      }
    }
  } 
}
</script>
```

:::

## 详情渲染

::: snippet 可在`el-form`组件下，直接使用`value`属性用于数值的渲染

```html
<template>
  <el-form label-width="80px" size="small">
    <el-row>
      <eagle-form-item span="6" label="姓名" :value="model.name"></eagle-form-item>
      <eagle-form-item span="6" label="年龄" :value="model.age"></eagle-form-item>
      <eagle-form-item span="6" label="性别" :value="model.gender"></eagle-form-item>
    </el-row>
  </el-form>
</template>

<script>
export default {
  data() {
    return {
      model: { name: '张三', age: '31', gender: '男' },
    }
  } 
}
</script>
```

:::
