import axios from 'axios';

const request = axios.create({
  baseURL: 'http://xxx',
  timeout: 1000 * 60,
  withCredentials: true,
  headers: {
    'Content-Type': 'application/json; charset=utf-8',
    Authorization: 'Bearer xxx',
  },
});

// respone 拦截器
request.interceptors.response.use(
  response => {
    const { data = {}, config } = response;
    const { businessException, errorCode, message, success } = data;
    if (config && config.interceptors === false) {
      // 请求配置不做返回拦截的情况
      return response;
    } else {
      if (success) {
        return data;
      } else {
        return Promise.reject(response);
      }
    }
  },
  error => {
    return Promise.reject(error);
  },
);

export default request;
