export const stringify = json => {
  const urlEncode = (param, key, encode) => {
    if (param === null) return '';
    let paramStr = '';
    const t = typeof param;
    if (t === 'string' || t === 'number' || t === 'boolean') {
      paramStr = `&${key}=${encode === null || encode ? encodeURIComponent(param) : param}`;
    } else {
      for (const i in param) {
        if (i) {
          if (param[i] !== undefined && param[i] !== '' && !(param[i] && typeof param[i] === 'string' && /^\s+$/.test(param[i]))) {
            const k = key == null ? i : `${key}${param instanceof Array ? `[${i}]` : `.${i}`}`;
            paramStr += urlEncode(param[i], k, encode);
          }
        }
      }
    }
    return paramStr;
  };
  return urlEncode(json).substring(1);
};

export const parse = url => {
  let obj = {}; // 创建一个Object
  let reg = /[?&][^?&]+=[^?&]+/g; // 正则匹配 ?&开始 =拼接  非?&结束  的参数
  let arr = url.match(reg); // match() 方法可在字符串内检索指定的值，或找到一个或多个正则表达式的匹配。
  // arr数组形式 ['?id=12345','&a=b']
  if (arr) {
    arr.forEach(item => {
      /**
       * tempArr数组    ['id','12345']和['a','b']
       * 第一个是key，第二个是value
       * */
      let tempArr = item.substring(1).split('=');
      let key = decodeURIComponent(tempArr[0]);
      let val = decodeURIComponent(tempArr[1]);
      obj[key] = val;
    });
  }
  return obj;
};

export const urlParam = data => {
  return `${data ? `?${stringify(data)}` : ''}`;
};

/**
 * 清除首尾斜杠，便于拼接字符串
 * @param {*} str URL
 */
export const clear = str => {
  return str.replace(/^(\s|\/)+|(\s|\/)+$/g, '');
};
