import DefaultLayout from '@/views/layout/default';
import ComponentLayout from '@/views/layout/component';
import DevelopLayout from '@/views/layout/develop';
import DesignLayout from '@/views/layout/design';

// 开发指南的文档

const _guides = [
  {
    path: 'introduce',
    name: 'introduce',
    meta: { title: '简介' },
    component: () => import('@/views/docs/guide/introduce.md'),
  },
  {
    path: 'installation',
    name: 'installation',
    meta: { title: '安装' },
    component: () => import('@/views/docs/guide/installation.md'),
  },
];

// 组件页面的文档

const _components = [
  {
    group: '基础组件',
    children: [
      {
        path: 'select',
        name: 'select',
        meta: { title: 'Select 选择器' },
        component: () => import('@/views/docs/component/select.md'),
      },
      {
        path: 'upload',
        name: 'upload',
        meta: { title: 'Upload 上传' },
        component: () => import('@/views/docs/component/upload.md'),
      },
    ],
  },
  {
    group: '表单组件',
    children: [
      {
        path: 'form',
        name: 'form',
        meta: { title: 'Form 表单' },
        component: () => import('@/views/docs/component/form.md'),
      },
      {
        path: 'form-item',
        name: 'form-item',
        meta: { title: 'Form Item 表单项' },
        component: () => import('@/views/docs/component/form-item.md'),
      },
    ],
  },
  {
    group: '展示组件',
    children: [
      {
        path: 'table',
        name: 'table',
        meta: { title: 'Table 表格' },
        component: () => import('@/views/docs/component/table.md'),
      },
    ],
  },
  {
    group: '方案组件',
    children: [
      {
        path: 'schema-form',
        name: 'schema-form',
        meta: { title: 'Schema Form 表单' },
        component: () => import('@/views/docs/component/schema-form.md'),
      },
      {
        path: 'schema-filter',
        name: 'schema-filter',
        meta: { title: 'Schema Filter 筛选' },
        component: () => import('@/views/docs/component/schema-filter.md'),
      },
      {
        path: 'schema-table',
        name: 'schema-table',
        meta: { title: 'Schema Table 表格' },
        component: () => import('@/views/docs/component/schema-table.md'),
      },
      {
        path: 'schema-page',
        name: 'schema-page',
        meta: { title: 'Schema Page 页面' },
        component: () => import('@/views/docs/component/schema-page.md'),
      },
      {
        path: 'schema-select',
        name: 'schema-select',
        meta: { title: 'Schema Select 选择器' },
        component: () => import('@/views/docs/component/schema-select.md'),
      },
      {
        path: 'schema-transfer',
        name: 'schema-transfer',
        meta: { title: 'Schema Transfer 穿梭框' },
        component: () => import('@/views/docs/component/schema-transfer.md'),
      },
    ],
  },
];

const _others = [
  {
    path: 'other',
    name: 'other',
    meta: { title: '其它' },
    component: () => import('@/views/page/other'),
  },
];

let _components_children = [];
_components.forEach(data => {
  _components_children = [..._components_children, ...data.children];
});

const _develops = [
  {
    group: '混入开发',
    children: [
      {
        path: 'page',
        name: 'page',
        meta: { title: 'Mixin Page 标准页' },
        component: () => import('@/views/docs/develop/mixin/page.md'),
      },
      {
        path: 'orgin',
        name: 'orgin',
        meta: { title: 'Mixin Orgin 初始值' },
        component: () => import('@/views/docs/develop/mixin/origin.md'),
      },
    ],
  },
  {
    group: '方案开发',
    children: [
      {
        path: 'introduce',
        name: 'developSchemaIntroduce',
        meta: { title: 'Schema 介绍' },
        component: () => import('@/views/docs/develop/schema/introduce.md'),
      },
    ],
  },
];

let _develops_children = [];
_develops.forEach(data => {
  _develops_children = [..._develops_children, ...data.children];
});

const _designs = [
  {
    group: '表格',
    children: [
      {
        path: 'table',
        name: 'designTable',
        meta: { title: '表格设计规范' },
        component: () => import('@/views/docs/design/table.md'),
      },
    ],
  },
];

let _designs_children = [];
_designs.forEach(data => {
  _designs_children = [..._designs_children, ...data.children];
});

// 用于导航的页面
const _pages = [
  {
    path: '',
    meta: { title: '首页', path: '/index' },
    component: DefaultLayout,
    redirect: 'index',
    children: [
      {
        path: 'index',
        name: 'index',
        component: () => import('@/views/page/index'),
      },
    ],
  },
  {
    path: '/component',
    name: 'component',
    meta: { title: '组件', path: '/component' },
    component: ComponentLayout,
    redirect: `/component/${_guides[0].path}`,
    children: [..._components_children, ..._guides, ..._others],
  },
  {
    path: '/design',
    name: 'design',
    meta: { title: '设计', path: '/design' },
    component: DesignLayout,
    redirect: `/design/${_designs[0].children[0].path}`,
    children: [..._designs_children],
  },
  {
    path: '/develop',
    name: 'develop',
    meta: { title: '开发', path: '/develop' },
    component: DevelopLayout,
    redirect: `/develop/${_develops[0].children[0].path}`,
    children: [..._develops_children],
  },
];

export const pages = _pages;
export const guides = _guides;
export const components = _components;
export const others = _others;
export const develops = _develops;
export const designs = _designs;

export default [
  { path: '*', redirect: '/404', hidden: true },
  {
    path: '/404',
    name: '404',
    component: () => import('@/views/page/error/404'),
  },
  ..._pages,
];
