import Vue from 'vue';
import Router from 'vue-router';
import routes from '@/router/routes';
import NProgress from 'nprogress'; // 进度条

Vue.use(Router);

const router = new Router({
  mode: 'history',
  routes,
});

router.beforeEach((to, from, next) => {
  NProgress.start(); // 开启进度条
  next();
});

router.afterEach(() => {
  NProgress.done(); // 结束进度条
});

export default router;
