import MIX_ORIGIN from '@/mixins/origin'; // 初始值逻辑混入

export default {
  mixins: [MIX_ORIGIN],
  data() {
    return {
      auto: false, // 页面加载时自动查询
      tableData: [], // 表格数据
      loading: false, // 加载状态
      total: 0, // 数据总量
      currentPage: 1, // 当前页码
      pageSize: 10, // 分页大小
      pageSizes: [10, 20, 50, 100], // 分页大小选项
      layout: 'total, sizes, prev, pager, next, jumper', // 分页器默认设置
      searchModel: {}, // 搜索表单绑定值
      form: {}, // 常规表单绑定值
      submitting: false, // 提交状态
      selection: [], // 表格选中项
      collapsed: false, // 展开状态
    };
  },
  computed: {
    // 搜索栏折叠按钮文本
    toggleText() {
      return this.collapsed ? '收起' : '展开';
    },
    // 表格属性
    tableProps() {
      return {
        size: 'mini',
        rowKey: 'id',
        border: true,
        highlightCurrentRow: true,
        data: this.tableData,
      };
    },
    // 表格事件
    tableEvent() {
      return {
        'selection-change': this.onSelectionChange,
      };
    },
    // 分页参数
    pageParams() {
      return {
        currentPage: this.currentPage,
        pageSize: this.pageSize,
      };
    },
    // 分页器属性
    paginationProps() {
      return {
        'current-page': this.currentPage,
        'page-sizes': this.pageSizes,
        'page-size': this.pageSize,
        layout: this.layout,
        total: this.total,
      };
    },
    // 分页器事件
    paginationEvent() {
      return {
        'size-change': this.onPageSizeChange,
        'current-change': this.onCurrentPageChange,
      };
    },
  },
  created() {
    if (this.auto) {
      this.search();
    }
  },
  methods: {
    // 空Promise
    emptyPromise() {
      return new Promise(resolve => resolve());
    },
    // 重置查询
    onSearch() {
      this.currentPage = 1;
      this.loadData();
    },
    // 切换展开状态
    toggle() {
      this.collapsed = !this.collapsed;
    },
    // 查询数据
    search() {
      this.loadData();
    },
    // 加载数据
    async loadData() {
      this.loading = true;
      const params = {
        ...this.searchModel,
        ...this.pageParams,
      };
      const searchAPI = this.searchAPI || this.emptyPromise;
      await searchAPI(params)
        .then(response => {
          const { result = [], totalCount = 0 } = response || {};
          this.tableData = result || [];
          this.total = totalCount || 0;
        })
        .finally(() => {
          this.loading = false;
        });
    },
    // 重置搜索表单
    onReset() {
      this.searchModel = this.cloneDeep(this.originData).searchModel;
    },
    // 多选
    onSelectionChange(selection) {
      this.selection = selection;
    },
    // 切换当前页码
    onCurrentPageChange(value) {
      this.currentPage = value;
      this.$nextTick(this.loadData);
    },
    // 切换最大页码
    onPageSizeChange(value) {
      this.currentPage = 1;
      this.pageSize = value;
      this.$nextTick(this.loadData);
    },
  },
};
