export default {
  data() {
    return {
      originData: {},
    };
  },
  created() {
    const { originData, ...other } = this._data;
    this.originData = this.cloneDeep(other);
  },
  methods: {
    // 深克隆对象
    cloneDeep(obj) {
      if (typeof obj !== 'object') {
        return obj;
      }
      if (!obj) {
        return obj;
      }
      if (obj instanceof Date) {
        return new Date(obj);
      }
      if (obj instanceof RegExp) {
        return new RegExp(obj);
      }
      if (obj instanceof Function) {
        return obj;
      }
      let newObj;
      if (obj instanceof Array) {
        newObj = [];
        for (let i = 0, len = obj.length; i < len; i++) {
          newObj.push(this.cloneDeep(obj[i]));
        }
        return newObj;
      }
      newObj = {};
      for (let key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          if (typeof obj[key] !== 'object') {
            newObj[key] = obj[key];
          } else {
            newObj[key] = this.cloneDeep(obj[key]);
          }
        }
      }
      return newObj;
    },
    // 获取初始值
    getOriginData(key) {
      if (key) {
        return this.cloneDeep(this.originData)[key];
      }
      return this.cloneDeep(this.originData);
    },
  },
};
