import Vue from 'vue';
import App from '@/App.vue';
import router from '@/router';
import store from '@/store';
import request from '@/utils/request';
import ElementUI from 'element-ui';
import Eagle from '../packages';
import NProgress from 'nprogress';
import CodeSnippet from '@/components/code-snippet';
import axios from 'axios';
import '@/styles/index.scss';
import '@/styles/highlight.scss';
import '@/mixins/page.scss';
import MIX_PAGE from '@/mixins/page.js';
import MIX_ORIGIN from '@/mixins/origin';

window.MIX_PAGE = MIX_PAGE;
window.MIX_ORIGIN = MIX_ORIGIN;

// 进度条配置
NProgress.configure({ showSpinner: false });

// 注册代码片段组件
Vue.component('code-snippet', CodeSnippet);
// 注册饿了么UI
Vue.use(ElementUI);
// 注册Eagle组件库
Vue.use(Eagle);

Vue.prototype.$axios = axios;
Vue.prototype.$http = request;
Vue.config.productionTip = false;

new Vue({
  router,
  store,
  render: h => h(App),
}).$mount('#app');
