'use strict';

module.exports = {
  objExclude(obj = {}, exclude = []) {
    const result = {};
    Object.keys(obj).forEach(key => {
      if (exclude.indexOf(key) < 0) {
        result[key] = obj[key];
      }
    });
    return result;
  },
  objToQuery(obj, prefix) {
    const arr = [];
    Object.keys(obj).forEach(key => {
      arr.push(`${!prefix ? '' : `${prefix}.`}${key} like '%${obj[key]}%'`);
    });
    return arr.join(' and ');
  },
  objToSet(obj, prefix) {
    const arr = [];
    Object.keys(obj).forEach(key => {
      arr.push(`${!prefix ? '' : `${prefix}.`}${key} = ${obj[key]}`);
    });
    return arr.join(' , ');
  },
};
