'use strict';

const Service = require('egg').Service;
const objExclude = require('../util/common').objExclude;

class UserService extends Service {
  async count() {
    const result = await this.app.mysql.query('select count(*) as total from user');
    return result;
  }
  async add(data) {
    const result = await this.app.mysql.insert('user', data);
    return result;
  }
  async update(data) {
    const result = await this.app.mysql.update('user', data);
    return result;
  }
  async find(id) {
    const user = await this.app.mysql.get('user', { id });
    return user;
  }
  async list(data) {
    const { current = 1, pageSize = 10 } = data;
    const other = objExclude(data, [ 'current', 'pageSize' ]);
    const limit = Number(pageSize);
    const offset = Number((current - 1) * pageSize);
    const list = await this.app.mysql.select('user', { columns: [ 'id', 'name', 'username', 'role' ], where: other, limit, offset, orders: [[ 'role', 'asc' ]] });
    return list;
  }
  async remove(data) {
    const result = await this.app.mysql.delete('user', data);
    return result;
  }
  async login(data) {
    const { username, password } = data;
    const result = await this.app.mysql.query('select id, name, username, role from user where username = ? and password = ?', [ username, password ]);
    return result;
  }
  async validate(data) {
    const { username, password } = data;
    const result = await this.app.mysql.query('select id from user where username = ? and password = ?', [ username, password ]);
    return result;
  }
  async password(data) {
    const { id, oldPassword, newPassword } = data;
    const result = await this.app.mysql.query('update user set password = ? where id = ? and password = ?', [ newPassword, id, oldPassword ]);
    return result;
  }
}

module.exports = UserService;
