'use strict';

const Service = require('egg').Service;
const objExclude = require('../util/common').objExclude;

class DictService extends Service {
  async count() {
    const result = await this.app.mysql.query('select count(*) as total from dict');
    return result;
  }
  async add(data) {
    const result = await this.app.mysql.insert('dict', data);
    return result;
  }
  async update(data) {
    const result = await this.app.mysql.update('dict', data);
    return result;
  }
  async find(id) {
    const user = await this.app.mysql.get('dict', { id });
    return user;
  }
  async list(data) {
    const { current = 1, pageSize = 10 } = data;
    const other = objExclude(data, [ 'current', 'pageSize' ]);
    const limit = Number(pageSize);
    const offset = Number((current - 1) * pageSize);
    const list = await this.app.mysql.select('dict', { where: other, limit, offset, orders: [[ 'type', 'asc' ], [ 'code', 'asc' ]] });
    return list;
  }
  async remove(data) {
    const result = await this.app.mysql.delete('dict', data);
    return result;
  }
}

module.exports = DictService;
