'use strict';

const Service = require('egg').Service;
const objExclude = require('../util/common').objExclude;

class CustomerService extends Service {
  async count() {
    const result = await this.app.mysql.query('select count(*) as total from customer');
    return result;
  }
  async add(data) {
    const result = await this.app.mysql.insert('customer', data);
    return result;
  }
  async update(data) {
    const result = await this.app.mysql.update('customer', data);
    return result;
  }
  async find(id) {
    const user = await this.app.mysql.get('customer', { id });
    return user;
  }
  async list(data) {
    const { current = 1, pageSize = 10 } = data;
    const other = objExclude(data, [ 'current', 'pageSize' ]);
    const limit = Number(pageSize);
    const offset = Number((current - 1) * pageSize);
    const list = await this.app.mysql.select('customer', { where: other, limit, offset, orders: [[ 'type', 'asc' ]] });
    return list;
  }
  async remove(data) {
    const result = await this.app.mysql.delete('customer', data);
    return result;
  }
}

module.exports = CustomerService;
