'use strict';

/**
 * @param {Egg.Application} app - egg application
 */
module.exports = app => {
  const { router, controller } = app;
  router.get('/', controller.home.index);
  // 首页统计
  router.get('/statistic/count', controller.statistic.count);
  // 文件上传
  router.post('/file/upload', controller.file.upload);
  // 用户管理
  router.post('/user/password', controller.user.password);
  router.post('/user/validate', controller.user.validate);
  router.post('/user/login', controller.user.login);
  router.get('/user/list', controller.user.list);
  router.get('/user/:id', controller.user.info);
  router.post('/user', controller.user.add);
  router.put('/user', controller.user.update);
  router.post('/user/delete', controller.user.remove);
  // 数据字典
  router.get('/dict/list', controller.dict.list);
  router.get('/dict/:id', controller.dict.info);
  router.post('/dict', controller.dict.add);
  router.put('/dict', controller.dict.update);
  router.post('/dict/delete', controller.dict.remove);
  // 客户管理
  router.get('/customer/list', controller.customer.list);
  router.get('/customer/:id', controller.customer.info);
  router.post('/customer', controller.customer.add);
  router.put('/customer', controller.customer.update);
  router.post('/customer/delete', controller.customer.remove);
  // 合同管理
  router.get('/contract/analysis', controller.contract.analysis);
  router.get('/contract/list', controller.contract.list);
  router.get('/contract/:id', controller.contract.info);
  router.post('/contract', controller.contract.add);
  router.put('/contract', controller.contract.update);
  router.post('/contract/delete', controller.contract.remove);
  // 项目管理
  router.get('/project/analysis/user', controller.project.user_analysis);
  router.get('/project/analysis', controller.project.analysis);
  router.get('/project/list', controller.project.list);
  router.get('/project/:id', controller.project.info);
  router.post('/project', controller.project.add);
  router.put('/project', controller.project.update);
  router.post('/project/delete', controller.project.remove);
};
