'use strict';

const Controller = require('egg').Controller;

class StatisticController extends Controller {
  async count() {
    const ctx = this.ctx;
    try {
      const result = await ctx.service.statistic.count();
      this.ctx.body = {
        result,
        success: true,
      };
    } catch (error) {
      this.ctx.body = {
        success: false,
        error,
      };
    }
  }
}

module.exports = StatisticController;
