'use strict';

const fs = require('fs');
const path = require('path');
const Controller = require('egg').Controller;
const awaitWriteStream = require('await-stream-ready').write;
const sendToWormhole = require('stream-wormhole');
const uuid = require('node-uuid');

class FileController extends Controller {

  async upload() {
    const stream = await this.ctx.getFileStream();
    const filename = uuid.v1() + path.extname(stream.filename).toLowerCase();
    const target = path.join(this.config.baseDir, 'app/public', filename);
    const writeStream = fs.createWriteStream(target);
    try {
      await awaitWriteStream(stream.pipe(writeStream));
    } catch (err) {
      await sendToWormhole(stream);
      throw err;
    }

    this.ctx.body = { url: '/public/' + filename };
  }
}

module.exports = FileController;
