'use strict';

const qs = require('qs');
const Controller = require('egg').Controller;
const uuid = require('node-uuid');

class CustomerController extends Controller {
  async info() {
    const ctx = this.ctx;
    const id = ctx.params.id;
    try {
      const result = await ctx.service.customer.find(id);
      this.ctx.body = {
        result,
        success: true,
      };
    } catch (error) {
      this.ctx.body = {
        success: false,
        error,
      };
    }
  }
  async list() {
    const param = qs.parse(this.ctx.query);
    const ctx = this.ctx;
    try {
      const result = await ctx.service.customer.list(param);
      const total = await ctx.service.customer.count();
      this.ctx.body = {
        result,
        total: total[0].total,
        success: true,
      };
    } catch (error) {
      this.ctx.body = {
        success: false,
        error,
      };
    }
  }
  async add() {
    const ctx = this.ctx;
    const id = uuid.v4();
    const data = ctx.request.body;
    data.id = id;
    try {
      await ctx.service.customer.add(data);
      this.ctx.body = { success: true };
    } catch (error) {
      this.ctx.body = { success: false, error };
    }
  }
  async update() {
    const ctx = this.ctx;
    const data = ctx.request.body;
    try {
      await ctx.service.customer.update(data);
      this.ctx.body = { success: true };
    } catch (error) {
      this.ctx.body = { success: false, error };
    }
  }
  async remove() {
    const ctx = this.ctx;
    try {
      await ctx.service.customer.remove(ctx.request.body);
      this.ctx.body = { success: true };
    } catch (error) {
      this.ctx.body = { success: false, error };
    }
  }
}

module.exports = CustomerController;
